/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.keystore.loader.implementation;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.security.auth.callback.CallbackHandler;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoaderException;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemKeyStoreLoader
implements KeyStoreLoader {
    private static final String FILE_TYPE_PKCS12 = "PKCS12";
    private static final String FILE_TYPE_JKS = "JKS";
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private static final Logger logger = LoggerFactory.getLogger(FileSystemKeyStoreLoader.class);
    private File fileKeyStore = null;
    private InputStream inputStreamKeyStore = null;
    private String type = "PKCS12";

    public FileSystemKeyStoreLoader(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.file.invalid"));
        }
        this.setFileKeyStore(file);
    }

    public FileSystemKeyStoreLoader(InputStream inputStream, String type) {
        if (inputStream == null) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.input.stream.invalid"));
        }
        if (type == null || type.isEmpty()) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keystore.type.invalid"));
        }
        if (!type.equalsIgnoreCase(FILE_TYPE_PKCS12) && !type.equalsIgnoreCase(FILE_TYPE_JKS)) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keystore.type.invalid"));
        }
        this.setInputStreamKeyStore(inputStream);
        this.setType(type);
    }

    public FileSystemKeyStoreLoader(InputStream inputStream) {
        if (inputStream == null) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.input.stream.invalid"));
        }
        this.setInputStreamKeyStore(inputStream);
        this.setType(FILE_TYPE_PKCS12);
    }

    public File getFileKeyStore() {
        return this.fileKeyStore;
    }

    public void setFileKeyStore(File fileKeyStore) {
        this.fileKeyStore = fileKeyStore;
    }

    public InputStream getInputStreamKeyStore() {
        return this.inputStreamKeyStore;
    }

    public void setInputStreamKeyStore(InputStream inputStreamKeyStore) {
        this.inputStreamKeyStore = inputStreamKeyStore;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public KeyStore getKeyStore(String pinNumber) {
        logger.info("FileSystemKeyStoreLoader.getKeyStore()");
        KeyStore result = null;
        if (this.fileKeyStore != null) {
            if (this.fileKeyStore.getName().endsWith("p12") || this.fileKeyStore.getName().endsWith("pfx")) {
                try {
                    result = this.getKeyStoreWithType(pinNumber, FILE_TYPE_PKCS12);
                }
                catch (Throwable throwable) {
                    throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keyStore.pass", this.fileKeyStore.getName()), throwable);
                }
            }
            if (this.fileKeyStore.getName().endsWith("jks")) {
                try {
                    result = this.getKeyStoreWithType(pinNumber, FILE_TYPE_JKS);
                }
                catch (Throwable error) {
                    throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keyStore.pass", this.fileKeyStore.getName()), error);
                }
            }
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keyStore.unknow.format", this.fileKeyStore.getName()));
        }
        try {
            result = this.getKeyStoreWithTypeFromInputStream(pinNumber);
        }
        catch (Throwable throwable) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keyStore.pass"), throwable);
        }
        return result;
    }

    @Override
    public KeyStore getKeyStore() {
        logger.error("Nao implementado");
        return null;
    }

    private KeyStore getKeyStoreWithType(String pinNumber, String keyStoreType) {
        KeyStore result = null;
        try {
            result = KeyStore.getInstance(keyStoreType);
            char[] pwd = pinNumber == null ? null : pinNumber.toCharArray();
            FileInputStream is = new FileInputStream(this.fileKeyStore);
            result.load(is, pwd);
        }
        catch (Throwable error) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keystore.from.file"), error);
        }
        return result;
    }

    private KeyStore getKeyStoreWithTypeFromInputStream(String pinNumber) {
        KeyStore result = null;
        try {
            result = KeyStore.getInstance(this.type);
            char[] pwd = pinNumber == null ? null : pinNumber.toCharArray();
            result.load(this.inputStreamKeyStore, pwd);
        }
        catch (Throwable error) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.keystore.from.inputstream"), error);
        }
        return result;
    }

    @Override
    public void setCallbackHandler(CallbackHandler callback) {
    }
}

