/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.keystore.loader.factory;

import java.io.File;
import java.io.InputStream;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoaderException;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.keystore.loader.implementation.DriverKeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.implementation.FileSystemKeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.implementation.MSKeyStoreLoader;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreLoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreLoaderFactory.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    public static KeyStoreLoader factoryKeyStoreLoader() {
        logger.debug(coreMessagesBundle.getString("info.keystore.no.parameter"));
        if (Configuration.getInstance().getSO().toLowerCase().indexOf("indows") > 0) {
            logger.debug(coreMessagesBundle.getString("info.keystore.ms"));
            if (Configuration.getInstance().isMSCapiDisabled() || !Configuration.getInstance().isMSCAPI_ON()) {
                logger.debug(coreMessagesBundle.getString("info.keystore.ms.pkcs11"));
                return new DriverKeyStoreLoader();
            }
            logger.debug(coreMessagesBundle.getString("info.keystore.mscapi"));
            return new MSKeyStoreLoader();
        }
        logger.debug(coreMessagesBundle.getString("info.keystore.pkcs11"));
        return new DriverKeyStoreLoader();
    }

    public static KeyStoreLoader factoryKeyStoreLoader(File file) {
        return new FileSystemKeyStoreLoader(file);
    }

    public static KeyStoreLoader factoryKeyStoreLoader(InputStream inputStream) {
        return new FileSystemKeyStoreLoader(inputStream);
    }

    public static KeyStoreLoader factoryKeyStoreLoader(InputStream inputStream, String type) {
        return new FileSystemKeyStoreLoader(inputStream, type);
    }

    public static KeyStoreLoader factoryKeyStoreLoader(Class<? extends KeyStoreLoader> clazz) {
        if (clazz == null) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.parm.clazz.null"));
        }
        KeyStoreLoader result = null;
        try {
            result = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new KeyStoreLoaderException(coreMessagesBundle.getString("error.class.instance", clazz.getCanonicalName()));
        }
        return result;
    }
}

