/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.factory;

import org.demoiselle.signer.core.exception.SignerException;
import org.demoiselle.signer.core.util.MessagesBundle;

public abstract class GenericFactory<F> {
    private String className = null;
    private static final MessagesBundle coreMessagesBundle = new MessagesBundle();

    public F factory() {
        if (this.className == null) {
            this.className = this.getContentFromVariables(this.getVariableName());
        }
        F result = null;
        result = this.className != null && this.className.length() > 0 ? (F)this.factoryFromClassName(this.className) : (F)this.factoryDefault();
        return result;
    }

    public F factoryFromClassName(String className) {
        F result = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Throwable error) {
            throw new SignerException(coreMessagesBundle.getString("error.class.not.exist", className), error);
        }
        if (clazz != null) {
            try {
                result = (F)clazz.newInstance();
            }
            catch (Throwable error) {
                throw new SignerException(coreMessagesBundle.getString("error.class.incompatible", clazz.getCanonicalName()), error);
            }
        }
        return result;
    }

    private String getContentFromVariables(String key) {
        String content = System.getenv(key);
        if (content == null) {
            content = System.getenv(key.toLowerCase());
        }
        if (content == null) {
            content = System.getenv(key.toUpperCase());
        }
        if (content == null) {
            content = System.getProperty(key);
        }
        if (content == null) {
            content = System.getProperty(key.toLowerCase());
        }
        if (content == null) {
            content = System.getProperty(key.toUpperCase());
        }
        return content;
    }

    public abstract F factoryDefault();

    protected abstract String getVariableName();
}

