/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.lang.reflect.Field;
import java.security.cert.X509Certificate;
import org.demoiselle.signer.core.IOIDExtensionLoader;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.extension.ICPBrasilExtension;
import org.demoiselle.signer.core.util.MessagesBundle;

public class ICPBrasilExtensionLoader
implements IOIDExtensionLoader {
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    @Override
    public void load(Object object, Field field, X509Certificate x509) {
        if (field.isAnnotationPresent(ICPBrasilExtension.class)) {
            ICPBrasilExtension annotation = field.getAnnotation(ICPBrasilExtension.class);
            try {
                String keyValue;
                BasicCertificate cert = new BasicCertificate(x509);
                switch (annotation.type()) {
                    case CPF: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getCPF();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CNPJ: {
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getCNPJ();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getCNPJ();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case PIS_PASEP: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getNis();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getNis();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getNis();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case NIS: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getNis();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getNis();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getNis();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CEI: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getCEI();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getCEI();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CEI_PESSOA_FISICA: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getCEI();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CEI_PESSOA_JURIDICA: {
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getCEI();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case NAME: {
                        keyValue = cert.getName();
                        break;
                    }
                    case NAME_RESPONSIBLE_PESSOA_JURIDICA: {
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getResponsibleName();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CPF_RESPONSIBLE_PESSOA_JURIDICA: {
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getResponsibleCPF();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case EMAIL: {
                        keyValue = cert.getEmail();
                        break;
                    }
                    case BIRTH_DATE: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getBirthDate();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getBirthDate();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            if (cert.getICPBRCertificateEquipment().getBirthDate() != null) {
                                keyValue = cert.getICPBRCertificateEquipment().getBirthDate().toString();
                                break;
                            }
                            keyValue = "";
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case ID_NUMBER: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getRg();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getRg();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getRg();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case IDENTITY_DISPATCHER: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getIssuingAgencyRg();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getIssuingAgencyRg();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getIssuingAgencyRg();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case UF_IDENTITY_DISPATCHER: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getUfIssuingAgencyRg();
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = cert.getICPBRCertificatePJ().getUfIssuingAgencyRg();
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getUfIssuingAgencyRg();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case NUMBER_ELECTORAL_DOCUMENT: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getElectoralDocument();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case ZONE_ELECTORAL_DOCUMENT: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getZoneElectoralDocument();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case SECTION_ELECTORAL_DOCUMENT: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getSectionElectoralDocument();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CITY_ELECTORAL_DOCUMENT: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getCityElectoralDocument();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case UF_ELECTORAL_DOCUMENT: {
                        if (cert.hasCertificatePF()) {
                            keyValue = cert.getICPBRCertificatePF().getUFElectoralDocument();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case BUSINESS_NAME: {
                        if (cert.hasCertificateEquipment()) {
                            keyValue = cert.getICPBRCertificateEquipment().getCorporateName();
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CERTIFICATE_TYPE: {
                        if (cert.hasCertificatePF()) {
                            keyValue = "PF";
                            break;
                        }
                        if (cert.hasCertificatePJ()) {
                            keyValue = "PJ";
                            break;
                        }
                        if (cert.hasCertificateEquipment()) {
                            keyValue = "EA";
                            break;
                        }
                        keyValue = "";
                        break;
                    }
                    case CERTIFICATE_LEVEL: {
                        keyValue = cert.getCertificateLevel();
                        break;
                    }
                    default: {
                        throw new CertificateCoreException(coreMessagesBundle.getString("error.field.not.implemented", new Object[]{annotation.type()}));
                    }
                }
                try {
                    field.setAccessible(true);
                    field.set(object, keyValue);
                }
                catch (Exception e) {
                    throw new CertificateCoreException(coreMessagesBundle.getString("error.load.value.field", field.getName()), e);
                }
            }
            catch (Exception e) {
                throw new CertificateCoreException(coreMessagesBundle.getString("error.get.value.field", field.getName()), e);
            }
        }
    }
}

