/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import org.demoiselle.signer.core.util.Base64Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICPBR_CRL {
    private X509CRL x509crl = null;
    private final Logger logger = LoggerFactory.getLogger(ICPBR_CRL.class);

    public ICPBR_CRL(InputStream is) throws CRLException, CertificateException, NoSuchProviderException {
        this.x509crl = this.getInstance(is);
    }

    public ICPBR_CRL(byte[] data) throws CRLException, CertificateException, IOException, NoSuchProviderException {
        this.x509crl = this.getInstance(data);
    }

    private X509CRL getInstance(byte[] data) throws CRLException, IOException, CertificateException, NoSuchProviderException {
        X509CRL crl = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            crl = this.getInstance(bis);
            bis.close();
            bis = null;
        }
        catch (CRLException e) {
            this.logger.error(e.getMessage());
            byte[] data2 = null;
            try {
                data2 = Base64Utils.base64Decode(new String(data));
            }
            catch (Exception e2) {
                this.logger.error(e.getMessage());
                throw e;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data2);
            crl = this.getInstance(bis);
            bis.close();
            bis = null;
        }
        return crl;
    }

    private X509CRL getInstance(InputStream is) throws CRLException, CertificateException, NoSuchProviderException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509CRL crl = (X509CRL)cf.generateCRL(is);
        return crl;
    }

    public X509CRL getCRL() {
        return this.x509crl;
    }
}

