/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.demoiselle.signer.core.extension.CertificateExtra;
import org.demoiselle.signer.core.extension.ICPBRCertificateEquipment;
import org.demoiselle.signer.core.extension.ICPBRCertificatePF;
import org.demoiselle.signer.core.extension.ICPBRCertificatePJ;

public class ICPBRSubjectAlternativeNames {
    private String email = null;
    private String dns = null;
    private ICPBRCertificatePF icpBrCertPF = null;
    private ICPBRCertificatePJ icpBrCertPJ = null;
    private ICPBRCertificateEquipment icpBrCertEquipment = null;

    public ICPBRSubjectAlternativeNames(X509Certificate certificate) {
        String SN = this.getSNfromCertificate(certificate);
        CertificateExtra ce = new CertificateExtra(certificate);
        if (ce.isCertificatePF()) {
            this.icpBrCertPF = new ICPBRCertificatePF(ce.getOID_2_16_76_1_3_1(), ce.getOID_2_16_76_1_3_5(), ce.getOID_2_16_76_1_3_6());
        } else if (ce.isCertificatePJ()) {
            this.icpBrCertPJ = new ICPBRCertificatePJ(ce.getOID_2_16_76_1_3_2(), ce.getOID_2_16_76_1_3_3(), ce.getOID_2_16_76_1_3_4(), ce.getOID_2_16_76_1_3_7());
        } else if (ce.isCertificateEquipment()) {
            this.icpBrCertEquipment = new ICPBRCertificateEquipment(ce.getOID_2_16_76_1_3_2(), ce.getOID_2_16_76_1_3_3(), ce.getOID_2_16_76_1_3_4(), ce.getOID_2_16_76_1_3_8(), ce.getOID_2_5_29_17(), SN);
            this.dns = ce.getDNS();
        }
        this.email = ce.getEmail();
    }

    public boolean isCertificatePF() {
        return this.icpBrCertPF != null;
    }

    public ICPBRCertificatePF getICPBRCertificatePF() {
        return this.icpBrCertPF;
    }

    public boolean isCertificatePJ() {
        return this.icpBrCertPJ != null;
    }

    public ICPBRCertificatePJ getICPBRCertificatePJ() {
        return this.icpBrCertPJ;
    }

    public boolean isCertificateEquipment() {
        return this.icpBrCertEquipment != null;
    }

    public ICPBRCertificateEquipment getICPBRCertificateEquipment() {
        return this.icpBrCertEquipment;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDns() {
        return this.dns;
    }

    private String getSNfromCertificate(X509Certificate certificate) {
        try {
            X500Name x500name = new JcaX509CertificateHolder(certificate).getSubject();
            RDN[] rdns = x500name.getRDNs();
            for (int i = 0; i < rdns.length; ++i) {
                if (!rdns[i].getFirst().getType().getId().equals("2.5.4.5")) continue;
                return rdns[i].getFirst().getValue().toString();
            }
            return null;
        }
        catch (CertificateEncodingException e) {
            return null;
        }
    }
}

