/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_2;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_3;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_4;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_8;
import org.demoiselle.signer.core.oid.OID_2_5_29_17;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICPBRCertificateEquipment {
    private OID_2_16_76_1_3_2 oID_2_16_76_1_3_2 = null;
    private OID_2_16_76_1_3_3 oID_2_16_76_1_3_3 = null;
    private OID_2_16_76_1_3_4 oID_2_16_76_1_3_4 = null;
    private OID_2_16_76_1_3_8 oID_2_16_76_1_3_8 = null;
    private OID_2_5_29_17 oID_2_5_29_17 = null;
    private String serialNumber = null;
    private static final Logger logger = LoggerFactory.getLogger(ICPBRCertificateEquipment.class);

    public ICPBRCertificateEquipment(OID_2_16_76_1_3_2 oid1, OID_2_16_76_1_3_3 oid2, OID_2_16_76_1_3_4 oid3, OID_2_16_76_1_3_8 oid4, OID_2_5_29_17 oid5, String serialNumber) {
        this.oID_2_16_76_1_3_2 = oid1;
        this.oID_2_16_76_1_3_3 = oid2;
        this.oID_2_16_76_1_3_4 = oid3;
        this.oID_2_16_76_1_3_8 = oid4;
        this.oID_2_5_29_17 = oid5;
        this.serialNumber = serialNumber;
    }

    public String getResponsibleName() {
        if (this.oID_2_16_76_1_3_2 != null) {
            return this.oID_2_16_76_1_3_2.getName();
        }
        return null;
    }

    public String getCorporateName() {
        if (this.oID_2_16_76_1_3_8 != null) {
            return this.oID_2_16_76_1_3_8.getName();
        }
        return null;
    }

    public String getCNPJ() {
        String cnpj = "";
        if (this.oID_2_16_76_1_3_3 != null) {
            cnpj = this.oID_2_16_76_1_3_3.getCNPJ();
        }
        if (cnpj.isEmpty()) {
            cnpj = this.getSerialNumber();
        }
        return cnpj;
    }

    public Date getBirthDate() {
        if (this.oID_2_16_76_1_3_4 != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
                return sdf.parse(this.oID_2_16_76_1_3_4.getBirthDate());
            }
            catch (ParseException e) {
                logger.error(e.getMessage());
                return null;
            }
        }
        return null;
    }

    public String getNis() {
        if (this.oID_2_16_76_1_3_4 != null) {
            return this.oID_2_16_76_1_3_4.getNIS();
        }
        return null;
    }

    public String getRg() {
        if (this.oID_2_16_76_1_3_4 != null) {
            return this.oID_2_16_76_1_3_4.getRg();
        }
        return null;
    }

    public String getIssuingAgencyRg() {
        if (this.oID_2_16_76_1_3_4 != null) {
            return this.oID_2_16_76_1_3_4.getIssuingAgencyRg();
        }
        return null;
    }

    public String getUfIssuingAgencyRg() {
        if (this.oID_2_16_76_1_3_4 != null) {
            return this.oID_2_16_76_1_3_4.getUfIssuingAgencyRg();
        }
        return null;
    }

    public String getDNS() {
        if (this.oID_2_5_29_17 != null) {
            return this.oID_2_5_29_17.getData();
        }
        return null;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }
}

