/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.cert.X509Certificate;
import org.demoiselle.signer.core.IOIDExtensionLoader;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.extension.DefaultExtension;
import org.demoiselle.signer.core.util.MessagesBundle;

public class DefaultExtensionLoader
implements IOIDExtensionLoader {
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    @Override
    public void load(Object object, Field field, X509Certificate x509) {
        if (field.isAnnotationPresent(DefaultExtension.class)) {
            Object keyValue;
            DefaultExtension annotation = field.getAnnotation(DefaultExtension.class);
            BasicCertificate basicCertificate = new BasicCertificate(x509);
            switch (annotation.type()) {
                case CRL_URL: {
                    try {
                        keyValue = basicCertificate.getCRLDistributionPoint();
                        break;
                    }
                    catch (IOException e1) {
                        throw new CertificateCoreException(coreMessagesBundle.getString("error.get.value.field", field.getName()), e1);
                    }
                }
                case SERIAL_NUMBER: {
                    keyValue = basicCertificate.getSerialNumber();
                    break;
                }
                case ISSUER_DN: {
                    try {
                        keyValue = basicCertificate.getCertificateIssuerDN().toString();
                        break;
                    }
                    catch (IOException e1) {
                        throw new CertificateCoreException(coreMessagesBundle.getString("error.get.value.field", field.getName()), e1);
                    }
                }
                case SUBJECT_DN: {
                    try {
                        keyValue = basicCertificate.getCertificateSubjectDN().toString();
                        break;
                    }
                    catch (IOException e1) {
                        throw new CertificateCoreException(coreMessagesBundle.getString("error.get.value.field", field.getName()), e1);
                    }
                }
                case KEY_USAGE: {
                    keyValue = basicCertificate.getICPBRKeyUsage().toString();
                    break;
                }
                case PATH_LENGTH: {
                    keyValue = basicCertificate.getPathLength();
                    break;
                }
                case AUTHORITY_KEY_IDENTIFIER: {
                    try {
                        keyValue = basicCertificate.getAuthorityKeyIdentifier();
                        break;
                    }
                    catch (Exception e1) {
                        throw new CertificateCoreException(coreMessagesBundle.getString("error.get.value.field", field.getName()), e1);
                    }
                }
                case SUBJECT_KEY_IDENTIFIER: {
                    try {
                        keyValue = basicCertificate.getSubjectKeyIdentifier();
                        break;
                    }
                    catch (IOException e1) {
                        throw new CertificateCoreException(coreMessagesBundle.getString("error.get.value.field", field.getName()), e1);
                    }
                }
                case BEFORE_DATE: {
                    keyValue = basicCertificate.getBeforeDate();
                    break;
                }
                case AFTER_DATE: {
                    keyValue = basicCertificate.getAfterDate();
                    break;
                }
                case CERTIFICATION_AUTHORITY: {
                    keyValue = basicCertificate.isCACertificate();
                    break;
                }
                default: {
                    throw new CertificateCoreException(coreMessagesBundle.getString("error.field.not.implemented", new Object[]{annotation.type()}));
                }
            }
            try {
                field.setAccessible(true);
                field.set(object, keyValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                throw new CertificateCoreException(coreMessagesBundle.getString("error.load.value.field", field.getName()), e);
            }
        }
    }
}

