/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.demoiselle.signer.core.oid.OIDGeneric;
import org.demoiselle.signer.core.oid.OID_1_3_6_1_4_1_311_60_2_1_3;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_1;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_2;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_3;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_4;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_5;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_6;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_7;
import org.demoiselle.signer.core.oid.OID_2_16_76_1_3_8;
import org.demoiselle.signer.core.oid.OID_2_5_29_17;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExtra {
    private String email = "";
    private String dns = "";
    private final Map<String, OIDGeneric> extras = new HashMap<String, OIDGeneric>();
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();
    private static final Logger logger = LoggerFactory.getLogger(CertificateExtra.class);

    public CertificateExtra(X509Certificate certificate) {
        try {
            if (certificate.getSubjectAlternativeNames() == null) {
                return;
            }
            block8: for (List<?> list : certificate.getSubjectAlternativeNames()) {
                if (list.size() != 2) {
                    logger.error(coreMessagesBundle.getString("error.extra.size.incorret"));
                    throw new Exception(coreMessagesBundle.getString("error.extra.size.incorret"));
                }
                Object e1 = list.get(0);
                Object e2 = list.get(1);
                if (!(e1 instanceof Integer)) {
                    logger.error(coreMessagesBundle.getString("error.type.not.integer"));
                    throw new Exception(coreMessagesBundle.getString("error.type.not.integer"));
                }
                Integer tipo = (Integer)e1;
                switch (tipo) {
                    case 0: {
                        byte[] data = (byte[])e2;
                        OIDGeneric oid = OIDGeneric.getInstance(data);
                        this.extras.put(oid.getOid(), oid);
                        continue block8;
                    }
                    case 1: {
                        this.email = (String)e2;
                        continue block8;
                    }
                    case 2: {
                        this.dns = (String)e2;
                        continue block8;
                    }
                }
                logger.debug(coreMessagesBundle.getString("error.unknow.subject.alternative.name"));
            }
        }
        catch (CertificateParsingException e) {
            logger.debug(e.getMessage());
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    public boolean isCertificatePF() {
        return this.extras.get("2.16.76.1.3.1") != null;
    }

    public boolean isCertificatePJ() {
        return this.extras.get("2.16.76.1.3.7") != null;
    }

    public boolean isCertificateEquipment() {
        boolean isEquipment = false;
        boolean bl = isEquipment = !this.dns.isEmpty();
        if (!isEquipment) {
            isEquipment = this.extras.get("2.16.76.1.3.8") != null;
        }
        return isEquipment;
    }

    public OID_2_16_76_1_3_1 getOID_2_16_76_1_3_1() {
        return (OID_2_16_76_1_3_1)this.extras.get("2.16.76.1.3.1");
    }

    public OID_2_16_76_1_3_5 getOID_2_16_76_1_3_5() {
        return (OID_2_16_76_1_3_5)this.extras.get("2.16.76.1.3.5");
    }

    public OID_2_16_76_1_3_6 getOID_2_16_76_1_3_6() {
        return (OID_2_16_76_1_3_6)this.extras.get("2.16.76.1.3.6");
    }

    public OID_2_16_76_1_3_2 getOID_2_16_76_1_3_2() {
        return (OID_2_16_76_1_3_2)this.extras.get("2.16.76.1.3.2");
    }

    public OID_2_16_76_1_3_3 getOID_2_16_76_1_3_3() {
        return (OID_2_16_76_1_3_3)this.extras.get("2.16.76.1.3.3");
    }

    public OID_2_16_76_1_3_4 getOID_2_16_76_1_3_4() {
        return (OID_2_16_76_1_3_4)this.extras.get("2.16.76.1.3.4");
    }

    public OID_2_16_76_1_3_7 getOID_2_16_76_1_3_7() {
        return (OID_2_16_76_1_3_7)this.extras.get("2.16.76.1.3.7");
    }

    public OID_2_16_76_1_3_8 getOID_2_16_76_1_3_8() {
        return (OID_2_16_76_1_3_8)this.extras.get("2.16.76.1.3.8");
    }

    public String getEmail() {
        return this.email;
    }

    public String getDNS() {
        return this.dns;
    }

    public OID_1_3_6_1_4_1_311_60_2_1_3 getOID_1_3_6_1_4_1_311_60_2_1_3() {
        return (OID_1_3_6_1_4_1_311_60_2_1_3)this.extras.get("1.3.6.1.4.1.311.60.2.1.3");
    }

    public OID_2_5_29_17 getOID_2_5_29_17() {
        return (OID_2_5_29_17)this.extras.get("2.5.29.17");
    }
}

