/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.demoiselle.signer.core.extension.ICPBRCertificateEquipment;
import org.demoiselle.signer.core.extension.ICPBRCertificatePF;
import org.demoiselle.signer.core.extension.ICPBRCertificatePJ;
import org.demoiselle.signer.core.extension.ICPBRKeyUsage;
import org.demoiselle.signer.core.extension.ICPBRSubjectAlternativeNames;
import org.demoiselle.signer.core.extension.ICPBR_DN;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCertificate {
    private static final Logger logger = LoggerFactory.getLogger(BasicCertificate.class);
    public static final String OID_A1_CERTIFICATE = "2.16.76.1.2.1";
    public static final String OID_A2_CERTIFICATE = "2.16.76.1.2.2";
    public static final String OID_A3_CERTIFICATE = "2.16.76.1.2.3";
    public static final String OID_A4_CERTIFICATE = "2.16.76.1.2.4";
    public static final String OID_S1_CERTIFICATE = "2.16.76.1.2.101";
    public static final String OID_S2_CERTIFICATE = "2.16.76.1.2.102";
    public static final String OID_S3_CERTIFICATE = "2.16.76.1.2.103";
    public static final String OID_S4_CERTIFICATE = "2.16.76.1.2.104";
    private static final MessagesBundle coreMessagesBundle = new MessagesBundle();
    private X509Certificate certificate = null;
    private ICPBRSubjectAlternativeNames subjectAlternativeNames = null;
    private ICPBRKeyUsage keyUsage = null;
    private ICPBR_DN certificateFrom = null;
    private ICPBR_DN certificateFor = null;
    private ASN1InputStream varASN1InputStream;

    public BasicCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public BasicCertificate(byte[] data) throws Exception {
        this.certificate = this.getCertificate(data);
    }

    public BasicCertificate(InputStream is) throws IOException, Exception {
        this.certificate = this.getCertificate(is);
    }

    private X509Certificate getCertificate(InputStream is) throws CertificateException, Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)cf.generateCertificate(is);
    }

    private String toString(byte[] data) {
        if (data == null) {
            return null;
        }
        return this.toString(new BigInteger(1, data));
    }

    private String toString(BigInteger bi) {
        if (bi == null) {
            return null;
        }
        String ret = bi.toString(16);
        if (ret.length() % 2 == 1) {
            ret = "0" + ret;
        }
        return ret.toUpperCase();
    }

    private X509Certificate getCertificate(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        X509Certificate cert = this.getCertificate(bis);
        bis.close();
        bis = null;
        return cert;
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    public ICPBR_DN getCertificateIssuerDN() throws IOException {
        if (this.certificateFrom == null) {
            this.certificateFrom = new ICPBR_DN(this.certificate.getIssuerDN().getName());
        }
        return this.certificateFrom;
    }

    public String getSerialNumber() {
        return this.toString(this.certificate.getSerialNumber());
    }

    public ICPBR_DN getCertificateSubjectDN() throws IOException {
        if (this.certificateFor == null) {
            this.certificateFor = new ICPBR_DN(this.certificate.getSubjectDN().getName());
        }
        return this.certificateFor;
    }

    public String getNome() {
        try {
            String nome = this.getCertificateSubjectDN().getProperty("CN");
            int pos = nome.indexOf(58);
            if (pos > 0) {
                return nome.substring(0, pos);
            }
            return nome;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String getName() {
        try {
            String name = this.getCertificateSubjectDN().getProperty("CN");
            int pos = name.indexOf(58);
            if (pos > 0) {
                return name.substring(0, pos);
            }
            return name;
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    public Date getBeforeDate() {
        return this.certificate.getNotBefore();
    }

    public Date getAfterDate() {
        return this.certificate.getNotAfter();
    }

    public ICPBRKeyUsage getICPBRKeyUsage() {
        if (this.keyUsage == null) {
            this.keyUsage = new ICPBRKeyUsage(this.certificate);
        }
        return this.keyUsage;
    }

    public ICPBRSubjectAlternativeNames getICPBRSubjectAlternativeNames() {
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new ICPBRSubjectAlternativeNames(this.certificate);
        }
        return this.subjectAlternativeNames;
    }

    public String getEmail() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getEmail();
    }

    public boolean hasCertificatePF() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return false;
        }
        return this.getICPBRSubjectAlternativeNames().isCertificatePF();
    }

    public ICPBRCertificatePF getICPBRCertificatePF() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getICPBRCertificatePF();
    }

    public boolean hasCertificatePJ() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return false;
        }
        return this.getICPBRSubjectAlternativeNames().isCertificatePJ();
    }

    public ICPBRCertificatePJ getICPBRCertificatePJ() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getICPBRCertificatePJ();
    }

    public boolean hasCertificateEquipment() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return false;
        }
        return this.getICPBRSubjectAlternativeNames().isCertificateEquipment();
    }

    public ICPBRCertificateEquipment getICPBRCertificateEquipment() {
        if (this.getICPBRSubjectAlternativeNames() == null) {
            return null;
        }
        return this.getICPBRSubjectAlternativeNames().getICPBRCertificateEquipment();
    }

    public int getPathLength() {
        return this.certificate.getBasicConstraints();
    }

    public boolean isCACertificate() {
        return this.certificate.getBasicConstraints() >= 0;
    }

    public String getCertificateLevel() {
        try {
            DLSequence sequence = (DLSequence)this.getExtensionValue(Extension.certificatePolicies.getId());
            if (sequence != null) {
                for (int pos = 0; pos < sequence.size(); ++pos) {
                    DLSequence sequence2 = (DLSequence)sequence.getObjectAt(pos);
                    ASN1ObjectIdentifier policyIdentifier = (ASN1ObjectIdentifier)sequence2.getObjectAt(0);
                    PolicyInformation policyInformation = new PolicyInformation(policyIdentifier);
                    String id = policyInformation.getPolicyIdentifier().getId();
                    if (id == null) continue;
                    if (id.startsWith(OID_A1_CERTIFICATE)) {
                        return "A1";
                    }
                    if (id.startsWith(OID_A2_CERTIFICATE)) {
                        return "A2";
                    }
                    if (id.startsWith(OID_A3_CERTIFICATE)) {
                        return "A3";
                    }
                    if (id.startsWith(OID_A4_CERTIFICATE)) {
                        return "A4";
                    }
                    if (id.startsWith(OID_S1_CERTIFICATE)) {
                        return "S1";
                    }
                    if (id.startsWith(OID_S2_CERTIFICATE)) {
                        return "S2";
                    }
                    if (id.startsWith(OID_S3_CERTIFICATE)) {
                        return "S3";
                    }
                    if (!id.startsWith(OID_S4_CERTIFICATE)) continue;
                    return "S4";
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public List<String> getAuthorityInfoAccess() {
        ArrayList<String> address = new ArrayList<String>();
        try {
            byte[] authorityInfoAccess = this.certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (authorityInfoAccess != null && authorityInfoAccess.length > 0) {
                AuthorityInformationAccess infoAccess = AuthorityInformationAccess.getInstance(JcaX509ExtensionUtils.parseExtensionValue(authorityInfoAccess));
                for (AccessDescription desc : infoAccess.getAccessDescriptions()) {
                    if (desc.getAccessLocation().getTagNo() != 6) continue;
                    address.add(((DERIA5String)desc.getAccessLocation().getName()).getString());
                }
            }
            return address;
        }
        catch (Exception error) {
            logger.error(error.getMessage());
            return address;
        }
    }

    public String getAuthorityKeyIdentifier() {
        try {
            DLSequence sequence = (DLSequence)this.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (sequence == null || sequence.size() == 0) {
                return null;
            }
            DERTaggedObject taggedObject = (DERTaggedObject)sequence.getObjectAt(0);
            DEROctetString oct = (DEROctetString)taggedObject.getObject();
            return this.toString(oct.getOctets());
        }
        catch (Exception error) {
            logger.error(error.getMessage());
            return null;
        }
    }

    public String getSubjectKeyIdentifier() throws IOException {
        try {
            DEROctetString oct = (DEROctetString)this.getExtensionValue(Extension.subjectKeyIdentifier.getId());
            if (oct == null) {
                return null;
            }
            return this.toString(oct.getOctets());
        }
        catch (Exception error) {
            logger.error(error.getMessage());
            return null;
        }
    }

    public List<String> getCRLDistributionPoint() throws IOException {
        DistributionPoint[] distributionPoints;
        ArrayList<String> crlUrls = new ArrayList<String>();
        ASN1Primitive primitive = this.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (primitive == null) {
            return null;
        }
        CRLDistPoint crlDistPoint = CRLDistPoint.getInstance(primitive);
        for (DistributionPoint distributionPoint : distributionPoints = crlDistPoint.getDistributionPoints()) {
            GeneralName[] genNames;
            DistributionPointName dpn = distributionPoint.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            for (GeneralName genName : genNames = GeneralNames.getInstance(dpn.getName()).getNames()) {
                if (genName.getTagNo() != 6) continue;
                String url = DERIA5String.getInstance(genName.getName()).getString();
                crlUrls.add(url);
                logger.debug("Adicionando a url {}", (Object)url);
            }
        }
        return crlUrls;
    }

    public ASN1Primitive getExtensionValue(String oid) {
        try {
            byte[] extensionValue = this.certificate.getExtensionValue(oid);
            if (extensionValue == null) {
                return null;
            }
            this.varASN1InputStream = new ASN1InputStream(extensionValue);
            DEROctetString oct = (DEROctetString)this.varASN1InputStream.readObject();
            this.varASN1InputStream = new ASN1InputStream(oct.getOctets());
            return this.varASN1InputStream.readObject();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(0);
        try {
            SimpleDateFormat dtValidade = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            sb.append("*********************************\n");
            sb.append(coreMessagesBundle.getString("text.certicate.IssuerDN")).append(this.getCertificateIssuerDN()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.serialNumber")).append(this.getSerialNumber()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.subjectDN")).append(this.getCertificateSubjectDN()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.name")).append(this.getName()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.valid.from")).append(dtValidade.format(this.getBeforeDate())).append("ate").append(dtValidade.format(this.getAfterDate())).append("\n");
            sb.append("*********************************\n");
            if (this.hasCertificatePF()) {
                ICPBRCertificatePF tdPF = this.getICPBRCertificatePF();
                sb.append(coreMessagesBundle.getString("text.certicate.email")).append(this.getEmail()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.cpf")).append(tdPF.getCPF()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.birth.date")).append(tdPF.getBirthDate()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.pis")).append(tdPF.getNis()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.rg")).append(tdPF.getRg()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.rg.issuing.agency")).append(tdPF.getIssuingAgencyRg()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.rg.uf")).append(tdPF.getUfIssuingAgencyRg()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.cei")).append(tdPF.getCEI()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.voter.document")).append(tdPF.getElectoralDocument()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.section")).append(tdPF.getSectionElectoralDocument()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.zone")).append(tdPF.getZoneElectoralDocument()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.voter.city")).append(tdPF.getCityElectoralDocument()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.voter.uf")).append(tdPF.getUFElectoralDocument()).append("\n");
            }
            sb.append("*********************************\n");
            sb.append(coreMessagesBundle.getString("text.certicate.is.pj")).append(this.hasCertificatePJ()).append("\n");
            if (this.hasCertificatePJ()) {
                ICPBRCertificatePJ tdPJ = this.getICPBRCertificatePJ();
                sb.append(coreMessagesBundle.getString("text.certicate.cnpj")).append(tdPJ.getCNPJ()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.cei")).append(tdPJ.getCEI()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.nis")).append(tdPJ.getNis()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.responsible")).append(tdPJ.getResponsibleName()).append("\n");
            }
            sb.append("*********************************\n");
            sb.append(coreMessagesBundle.getString("text.certicate.is.equipment")).append(this.hasCertificateEquipment()).append("\n");
            if (this.hasCertificateEquipment()) {
                ICPBRCertificateEquipment tdEq = this.getICPBRCertificateEquipment();
                sb.append(coreMessagesBundle.getString("text.certicate.cnpj")).append(tdEq.getCNPJ()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.nis")).append(tdEq.getNis()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.bussiness.name")).append(tdEq.getCorporateName()).append("\n");
                sb.append(coreMessagesBundle.getString("text.certicate.responsible")).append(tdEq.getResponsibleName()).append("\n");
            }
            sb.append("*********************************\n");
            sb.append(coreMessagesBundle.getString("text.certicate.is.ca")).append(this.isCACertificate()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.pahtLenth")).append(this.getPathLength()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.type")).append(this.getCertificateLevel()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.type.use")).append(this.getICPBRKeyUsage()).append("\n");
            sb.append("*********************************\n");
            sb.append(coreMessagesBundle.getString("text.certicate.authority.key")).append(this.getAuthorityKeyIdentifier()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.Authority.info.acess")).append(this.getAuthorityInfoAccess()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.subject.key")).append(this.getSubjectKeyIdentifier()).append("\n");
            sb.append(coreMessagesBundle.getString("text.certicate.crl.url")).append(this.getCRLDistributionPoint()).append("\n");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return sb.toString();
    }
}

