/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.ca.manager;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CAManagerCache {
    private static CAManagerCache instance;
    private Map<String, Collection<X509Certificate>> cachedCertificates = new HashMap<String, Collection<X509Certificate>>();
    private Map<String, Boolean> isCAofCertificate = new HashMap<String, Boolean>();

    private CAManagerCache() {
    }

    public static CAManagerCache getInstance() {
        if (instance == null) {
            instance = new CAManagerCache();
        }
        return instance;
    }

    Collection<X509Certificate> getCachedCertificatesFor(X509Certificate certificate) {
        return this.cachedCertificates.get(this.getCertificateIdentificator(certificate));
    }

    synchronized void addCertificate(X509Certificate certificate, Collection<X509Certificate> certificates) {
        this.cachedCertificates.put(this.getCertificateIdentificator(certificate), certificates);
    }

    Boolean getIsCAofCertificate(X509Certificate ca, X509Certificate certificate) {
        String key = this.getCertificateIdentificator(ca) + "|" + this.getCertificateIdentificator(certificate);
        return this.isCAofCertificate.containsKey(key) ? this.isCAofCertificate.get(key) : null;
    }

    synchronized void setIsCAofCertificate(X509Certificate ca, X509Certificate certificate, boolean value) {
        String key = this.getCertificateIdentificator(ca) + "|" + this.getCertificateIdentificator(certificate);
        this.isCAofCertificate.put(key, value);
    }

    public synchronized void invalidate() {
        this.cachedCertificates.clear();
        this.isCAofCertificate.clear();
    }

    private String getCertificateIdentificator(X509Certificate certificate) {
        return certificate.getSubjectDN().getName() + certificate.getSerialNumber().toString();
    }
}

