/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core.ca.manager;

import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import javax.security.auth.x500.X500Principal;
import org.demoiselle.signer.core.ca.manager.CAManagerCache;
import org.demoiselle.signer.core.ca.manager.CAManagerConfiguration;
import org.demoiselle.signer.core.ca.manager.CAManagerException;
import org.demoiselle.signer.core.ca.provider.ProviderCA;
import org.demoiselle.signer.core.ca.provider.ProviderCAFactory;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAManager {
    private static final String CN = "CN";
    private static final CAManager instance = new CAManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(CAManager.class);
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    private CAManager() {
    }

    public static CAManager getInstance() {
        return instance;
    }

    public boolean validateRootCAs(Collection<X509Certificate> cas, X509Certificate certificate) {
        boolean valid = false;
        for (X509Certificate ca : cas) {
            try {
                this.validateRootCA(ca, certificate);
                valid = true;
                break;
            }
            catch (CAManagerException error) {
                LOGGER.debug(error.getMessage());
            }
        }
        if (!valid) {
            LOGGER.error(coreMessagesBundle.getString("error.no.authority"));
            throw new CAManagerException(coreMessagesBundle.getString("error.no.authority"));
        }
        return true;
    }

    public boolean validateRootCA(X509Certificate ca, X509Certificate certificate) {
        if (ca == null) {
            LOGGER.error(coreMessagesBundle.getString("error.root.ca.not.informed"));
            throw new CAManagerException(coreMessagesBundle.getString("error.root.ca.not.informed"));
        }
        if (!this.isRootCA(ca)) {
            LOGGER.error(coreMessagesBundle.getString("error.not.root"));
            throw new CAManagerException(coreMessagesBundle.getString("error.not.root"));
        }
        Collection<X509Certificate> acs = this.getCertificateChain(certificate);
        if (acs == null || acs.isEmpty()) {
            LOGGER.error(coreMessagesBundle.getString("error.get.chain"));
            throw new CAManagerException(coreMessagesBundle.getString("error.get.chain"));
        }
        X509Certificate rootCA = null;
        for (X509Certificate x509 : acs) {
            if (!this.isRootCA(x509)) continue;
            rootCA = x509;
            break;
        }
        if (rootCA == null) {
            LOGGER.error(coreMessagesBundle.getString("error.root.ca.not.found"));
            throw new CAManagerException(coreMessagesBundle.getString("error.root.ca.not.found"));
        }
        if (!this.isCAofCertificate(rootCA, ca)) {
            LOGGER.error(coreMessagesBundle.getString("error.root.ca.not.chain"));
            throw new CAManagerException(coreMessagesBundle.getString("error.root.ca.not.chain"));
        }
        return true;
    }

    public boolean isRootCA(X509Certificate ca) {
        if (ca == null) {
            return false;
        }
        return this.isCAofCertificate(ca, ca);
    }

    public boolean isCAofCertificate(X509Certificate ca, X509Certificate certificate) {
        CAManagerCache managerCache = CAManagerCache.getInstance();
        boolean isCached = CAManagerConfiguration.getInstance().isCached();
        try {
            Boolean isValid;
            LOGGER.debug(coreMessagesBundle.getString("info.ca.cache", isCached));
            if (isCached && null != (isValid = managerCache.getIsCAofCertificate(ca, certificate))) {
                return isValid;
            }
            certificate.verify(ca.getPublicKey());
            LOGGER.debug(coreMessagesBundle.getString("info.ca.validated"));
            if (isCached) {
                managerCache.setIsCAofCertificate(ca, certificate, true);
            }
            return true;
        }
        catch (InvalidKeyException | SignatureException error) {
            LOGGER.debug(coreMessagesBundle.getString("error.ca.verify.certificate.signature", error.getMessage()));
            if (isCached) {
                managerCache.setIsCAofCertificate(ca, certificate, false);
            }
            return false;
        }
        catch (CertificateException error) {
            LOGGER.error(coreMessagesBundle.getString("error.certificate.exception"), error);
            throw new CAManagerException(coreMessagesBundle.getString("error.certificate.exception"), error);
        }
        catch (NoSuchAlgorithmException error) {
            LOGGER.error(coreMessagesBundle.getString("error.no.such.algorithm"), error);
            throw new CAManagerException(coreMessagesBundle.getString("error.no.such.algorithm"), error);
        }
        catch (NoSuchProviderException error) {
            LOGGER.error(coreMessagesBundle.getString("error.no.such.provider"), error);
            throw new CAManagerException(coreMessagesBundle.getString("error.no.such.provider"), error);
        }
    }

    public Certificate[] getCertificateChainArray(X509Certificate certificate) {
        LinkedList chain = (LinkedList)this.getCertificateChain(certificate);
        if (chain == null || chain.isEmpty()) {
            return new Certificate[0];
        }
        Certificate[] result = new Certificate[chain.size()];
        for (int i = 0; i < chain.size(); ++i) {
            result[i] = (Certificate)chain.get(i);
        }
        return result;
    }

    public Collection<X509Certificate> getCertificateChain(X509Certificate certificate) {
        CAManagerConfiguration config = CAManagerConfiguration.getInstance();
        LinkedList<X509Certificate> result = new LinkedList<X509Certificate>();
        if (config.isCached()) {
            LOGGER.debug(coreMessagesBundle.getString("info.cache.mode", config.isCached()));
            CAManagerCache managerCache = CAManagerCache.getInstance();
            Collection<X509Certificate> certificates = managerCache.getCachedCertificatesFor(certificate);
            if (certificates != null) {
                return certificates;
            }
        }
        result.add(certificate);
        if (this.isRootCA(certificate)) {
            return result;
        }
        Collection<ProviderCA> providers = ProviderCAFactory.getInstance().factory();
        boolean ok = false;
        for (ProviderCA provider : providers) {
            try {
                String varNameProvider = provider.getName();
                LOGGER.debug(coreMessagesBundle.getString("info.searching.on.provider", varNameProvider));
                Collection<X509Certificate> acs = provider.getCAs();
                for (X509Certificate ac : acs) {
                    String acCN;
                    X500Principal issuer = certificate.getIssuerX500Principal();
                    if (issuer == null) continue;
                    String issuerName = certificate.getIssuerX500Principal().getName();
                    String certificateCnIssuer = this.getCN(issuerName);
                    if (certificateCnIssuer.equalsIgnoreCase(acCN = this.getCN(ac.getSubjectX500Principal().getName())) && this.isCAofCertificate(ac, certificate)) {
                        result.add(ac);
                        X509Certificate acFromAc = null;
                        for (X509Certificate ac2 : acs) {
                            String ac2CN;
                            String acCnIssuer = this.getCN(ac.getIssuerX500Principal().getName());
                            if (!acCnIssuer.equalsIgnoreCase(ac2CN = this.getCN(ac2.getSubjectX500Principal().getName())) || !this.isCAofCertificate(ac2, ac)) continue;
                            acFromAc = ac2;
                        }
                        while (acFromAc != null) {
                            result.add(acFromAc);
                            if (this.isRootCA(acFromAc)) {
                                ok = true;
                                break;
                            }
                            for (X509Certificate ac3 : acs) {
                                String ac3CN;
                                String acFromAcIssuerCN = this.getCN(acFromAc.getIssuerX500Principal().getName());
                                if (!acFromAcIssuerCN.equalsIgnoreCase(ac3CN = this.getCN(ac3.getSubjectX500Principal().getName())) || !this.isCAofCertificate(ac3, acFromAc)) continue;
                                acFromAc = ac3;
                            }
                        }
                    }
                    if (!ok) continue;
                    break;
                }
                LOGGER.debug(coreMessagesBundle.getString("info.found.levels", result.size(), provider.getName()));
                if (ok) break;
                LOGGER.info(coreMessagesBundle.getString("warn.no.chain.on.provider", provider.getName()));
            }
            catch (Exception error) {
                LOGGER.warn(coreMessagesBundle.getString("error.no.ca", provider.getName()));
            }
        }
        if (!ok) {
            LOGGER.error(coreMessagesBundle.getString("erro.no.chain.provided", certificate.getSubjectDN()));
            throw new CAManagerException(coreMessagesBundle.getString("erro.no.chain.provided", certificate.getSubjectDN()));
        }
        if (config.isCached() && !result.isEmpty()) {
            CAManagerCache.getInstance().addCertificate(certificate, result);
        }
        return result;
    }

    private X509Certificate getCAFromCertificate(Collection<X509Certificate> certificates, X509Certificate certificate) {
        if (this.isRootCA(certificate) || certificates == null || certificates.isEmpty()) {
            return null;
        }
        for (X509Certificate ca : certificates) {
            if (!this.isCAofCertificate(ca, certificate)) continue;
            return ca;
        }
        return null;
    }

    public Certificate[] getCertificateChainArray(KeyStore keyStore, String privateKeyPass, String certificateAlias) {
        Certificate[] certificateChain;
        try {
            keyStore.getKey(certificateAlias, privateKeyPass.toCharArray());
            certificateChain = keyStore.getCertificateChain(certificateAlias);
            if (certificateChain == null) {
                LOGGER.error(coreMessagesBundle.getString("error.no.chain.alias", certificateAlias));
                throw new CAManagerException(coreMessagesBundle.getString("error.no.chain.alias", certificateAlias));
            }
        }
        catch (KeyStoreException error) {
            LOGGER.error(coreMessagesBundle.getString("error.keystore.type"), error);
            throw new CAManagerException(coreMessagesBundle.getString("error.keystore.type"), error);
        }
        catch (UnrecoverableKeyException error) {
            LOGGER.error(coreMessagesBundle.getString("error.unrecoverable.key"), error);
            throw new CAManagerException(coreMessagesBundle.getString("error.unrecoverable.key"), error);
        }
        catch (NoSuchAlgorithmException error) {
            LOGGER.error(coreMessagesBundle.getString("error.no.such.algorithm"), error);
            throw new CAManagerException(coreMessagesBundle.getString("error.no.such.algorithm"), error);
        }
        return certificateChain;
    }

    public Collection<X509Certificate> getCertificateChain(KeyStore keyStore, String privateKeyPass, String certificateAlias) {
        LinkedList<X509Certificate> result;
        Certificate[] certificateChain = this.getCertificateChainArray(keyStore, privateKeyPass, certificateAlias);
        if (certificateChain != null) {
            result = new LinkedList<X509Certificate>();
            for (Certificate certificate : certificateChain) {
                result.add((X509Certificate)certificate);
            }
        } else {
            LOGGER.error(coreMessagesBundle.getString("error.no.chain.alias"));
            throw new CAManagerException(coreMessagesBundle.getString("error.no.chain.alias"));
        }
        return result;
    }

    private String getCN(String x500) {
        int indexCN = x500.indexOf(CN);
        if (indexCN >= 0) {
            int indexComa = x500.indexOf(44, indexCN);
            if (indexComa < 0) {
                return x500.substring(indexCN);
            }
            return x500.substring(indexCN, indexComa);
        }
        return x500;
    }
}

