/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.demoiselle.signer.core.CertificateLoaderImpl;
import org.demoiselle.signer.core.IOIDExtensionLoader;
import org.demoiselle.signer.core.IValidator;
import org.demoiselle.signer.core.OIDExtension;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.CRLValidator;
import org.demoiselle.signer.core.validator.PeriodValidator;

public class CertificateManager {
    private X509Certificate x509;
    private Collection<IValidator> validators;
    private static MessagesBundle coreMessagesBundle = new MessagesBundle();

    public CertificateManager(X509Certificate x509) throws CertificateValidatorException {
        this(x509, true, new IValidator[0]);
    }

    public CertificateManager(X509Certificate x509, IValidator ... validators) throws CertificateValidatorException {
        this(x509, true, validators);
    }

    public CertificateManager(String pinNumber, IValidator ... validators) throws CertificateValidatorException {
        this(pinNumber, true, validators);
    }

    public CertificateManager(File fileX509, IValidator ... validators) throws CertificateValidatorException {
        this(fileX509, true, validators);
    }

    public CertificateManager(X509Certificate x509, boolean loadDefaultValidators, IValidator ... validators) throws CertificateValidatorException {
        this.init(x509, loadDefaultValidators, validators);
    }

    public CertificateManager(String pinNumber, boolean loadDefaultValidators, IValidator ... validators) throws CertificateValidatorException {
        CertificateLoaderImpl loader = new CertificateLoaderImpl();
        X509Certificate x509 = loader.loadFromToken(pinNumber);
        this.init(x509, loadDefaultValidators, validators);
    }

    public CertificateManager(File fileX509, boolean loadDefaultValidators, IValidator ... validators) throws CertificateValidatorException {
        CertificateLoaderImpl loader = new CertificateLoaderImpl();
        X509Certificate x509 = loader.load(fileX509);
        this.init(x509, loadDefaultValidators, validators);
    }

    private void init(X509Certificate x509, boolean loadDefaultValidators, IValidator ... validators) throws CertificateValidatorException, CertificateValidatorCRLException {
        this.x509 = x509;
        this.validators = new ArrayList<IValidator>();
        if (loadDefaultValidators) {
            this.loadDefaultValidators();
        }
        for (IValidator validator : validators) {
            this.validators.add(validator);
        }
        for (IValidator validator : this.validators) {
            validator.validate(x509);
        }
    }

    public void load(Object object) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(OIDExtension.class)) continue;
                OIDExtension oid = annotation.annotationType().getAnnotation(OIDExtension.class);
                Class<? extends IOIDExtensionLoader> loaderClass = oid.loader();
                try {
                    IOIDExtensionLoader loader = loaderClass.newInstance();
                    loader.load(object, field, this.x509);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CertificateCoreException(coreMessagesBundle.getString("error.initialize.attribute", field.getName()), e);
                }
            }
        }
    }

    public <T> T load(Class<T> clazz) {
        T object;
        try {
            object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CertificateCoreException(coreMessagesBundle.getString("error.new.instance", clazz.getName()), e);
        }
        this.load(object);
        return object;
    }

    private void loadDefaultValidators() {
        this.validators.add(new PeriodValidator());
        if (ConfigurationRepo.getInstance().isValidateLCR()) {
            this.validators.add(new CRLValidator());
        }
    }
}

