/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.demoiselle.signer.core.CertificateLoader;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;

public class CertificateLoaderImpl
implements CertificateLoader {
    private KeyStore keyStore;

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    @Override
    public X509Certificate load(File file) {
        try {
            FileInputStream fileInput = new FileInputStream(file);
            Security.addProvider(new BouncyCastleProvider());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            return (X509Certificate)cf.generateCertificate(fileInput);
        }
        catch (FileNotFoundException e) {
            throw new CertificateCoreException("FileNotFoundException", e);
        }
        catch (CertificateException e) {
            throw new CertificateCoreException("CertificateException", e);
        }
        catch (NoSuchProviderException e) {
            throw new CertificateCoreException("NoSuchProviderException", e);
        }
    }

    @Override
    public X509Certificate loadFromToken() {
        return this.loadFromToken(null);
    }

    @Override
    public X509Certificate loadFromToken(String pinNumber) {
        if (this.keyStore == null) {
            KeyStoreLoader keyStoreLoader = KeyStoreLoaderFactory.factoryKeyStoreLoader();
            this.keyStore = keyStoreLoader.getKeyStore();
        }
        try {
            String alias = this.keyStore.aliases().nextElement();
            return (X509Certificate)this.keyStore.getCertificateChain(alias)[0];
        }
        catch (KeyStoreException e) {
            throw new CertificateCoreException("", e);
        }
    }

    @Override
    public X509Certificate loadFromToken(String pinNumber, String alias) {
        if (this.keyStore == null) {
            KeyStoreLoader keyStoreLoader = KeyStoreLoaderFactory.factoryKeyStoreLoader();
            this.keyStore = keyStoreLoader.getKeyStore();
        }
        try {
            return (X509Certificate)this.keyStore.getCertificateChain(alias)[0];
        }
        catch (KeyStoreException e) {
            throw new CertificateCoreException("", e);
        }
    }
}

