/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.chain.iti.provider;

import java.io.InputStream;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.demoiselle.signer.core.ca.provider.ProviderCA;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITIProviderCA
implements ProviderCA {
    protected static MessagesBundle chainMessagesBundle = new MessagesBundle();
    private static final Logger logger = LoggerFactory.getLogger(ITIProviderCA.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<X509Certificate> getCAs() {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try {
            InputStream AutoridadeCertificadoraRaizdoGovernoFederaldoBrasilv1 = ITIProviderCA.class.getClassLoader().getResourceAsStream("trustedca/AutoridadeCertificadoraRaizdoGovernoFederaldoBrasilv1.crt");
            InputStream ACFinaldoGovernoFederaldoBrasilv1 = ITIProviderCA.class.getClassLoader().getResourceAsStream("trustedca/ACFinaldoGovernoFederaldoBrasilv1.crt");
            InputStream ACIntermediariadoGovernoFederaldoBrasilv1 = ITIProviderCA.class.getClassLoader().getResourceAsStream("trustedca/ACIntermediariadoGovernoFederaldoBrasilv1.crt");
            Security.addProvider(new BouncyCastleProvider());
            logger.debug(chainMessagesBundle.getString("info.provider.name.serpro.neosigner"));
            result.add((X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(AutoridadeCertificadoraRaizdoGovernoFederaldoBrasilv1));
            result.add((X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(ACFinaldoGovernoFederaldoBrasilv1));
            result.add((X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(ACIntermediariadoGovernoFederaldoBrasilv1));
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            return result;
        }
    }

    @Override
    public String getName() {
        return chainMessagesBundle.getString("info.provider.name.iti.gov");
    }
}

