/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.chain.icp.brasil.provider.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.demoiselle.signer.chain.icp.brasil.provider.impl.ICPBrasilProviderCAException;
import org.demoiselle.signer.core.ca.provider.ProviderCA;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICPBrasilProviderCA
implements ProviderCA {
    private static MessagesBundle chainMessagesBundle = new MessagesBundle();
    Logger LOGGER = LoggerFactory.getLogger(ICPBrasilProviderCA.class);

    @Override
    public Collection<X509Certificate> getCAs() {
        KeyStore keyStore = this.getKeyStore();
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                X509Certificate root = (X509Certificate)keyStore.getCertificate(alias);
                result.add(root);
            }
        }
        catch (KeyStoreException ex) {
            this.LOGGER.error(chainMessagesBundle.getString("error.load.keystore", ex.getMessage()), ex);
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.load.keystore", ex.getMessage()), ex);
        }
        return result;
    }

    private KeyStore getKeyStore() {
        KeyStore keyStore = null;
        this.LOGGER.debug(chainMessagesBundle.getString("info.ca.component"));
        try {
            InputStream is = ICPBrasilProviderCA.class.getClassLoader().getResourceAsStream("cadeiasicpbrasil.bks");
            Security.addProvider(new BouncyCastleProvider());
            keyStore = KeyStore.getInstance("BKS", "BC");
            keyStore.load(is, "serprosigner".toCharArray());
        }
        catch (KeyStoreException ex) {
            this.LOGGER.error(chainMessagesBundle.getString("error.load.keystore", ex.getMessage()), ex);
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.load.keystore", ex.getMessage()), ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.LOGGER.error(chainMessagesBundle.getString("error.no.algorithm", ex.getMessage()), ex);
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.no.algorithm", ex.getMessage()), ex);
        }
        catch (CertificateException ex) {
            this.LOGGER.error(chainMessagesBundle.getString("error.jks.certificate", ex.getMessage()), ex);
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.jks.certificate", ex.getMessage()), ex);
        }
        catch (IOException ex) {
            this.LOGGER.error(chainMessagesBundle.getString("error.io", ex.getMessage()), ex);
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.io", ex.getMessage()), ex);
        }
        catch (NoSuchProviderException ex) {
            this.LOGGER.error(chainMessagesBundle.getString("error.io", ex.getMessage()), ex);
            throw new ICPBrasilProviderCAException(chainMessagesBundle.getString("error.io", ex.getMessage()), ex);
        }
        return keyStore;
    }

    @Override
    public String getName() {
        return chainMessagesBundle.getString("info.provider.name.demoiselle");
    }
}

