/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.util.Store;

public class SMIMESignedGenerator
extends SMIMEGenerator {
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    public static final String ENCRYPTION_ECGOST3410_2012_256 = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256.getId();
    public static final String ENCRYPTION_ECGOST3410_2012_512 = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512.getId();
    private static final String CERTIFICATE_MANAGEMENT_CONTENT = "application/pkcs7-mime; name=smime.p7c; smime-type=certs-only";
    private static final String DETACHED_SIGNATURE_TYPE = "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data";
    private static final String ENCAPSULATED_SIGNED_CONTENT_TYPE = "application/pkcs7-mime; name=smime.p7m; smime-type=signed-data";
    public static final Map RFC3851_MICALGS;
    public static final Map RFC5751_MICALGS;
    public static final Map STANDARD_MICALGS;
    private final String defaultContentTransferEncoding;
    private final Map micAlgs;
    private List _certStores = new ArrayList();
    private List certStores = new ArrayList();
    private List crlStores = new ArrayList();
    private List attrCertStores = new ArrayList();
    private List signerInfoGens = new ArrayList();
    private List _signers = new ArrayList();
    private List _oldSigners = new ArrayList();
    private List _attributeCerts = new ArrayList();
    private Map _digests = new HashMap();

    private static MailcapCommandMap addCommands(MailcapCommandMap mailcapCommandMap) {
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        return mailcapCommandMap;
    }

    public SMIMESignedGenerator() {
        this("7bit", STANDARD_MICALGS);
    }

    public SMIMESignedGenerator(String string) {
        this(string, STANDARD_MICALGS);
    }

    public SMIMESignedGenerator(Map map) {
        this("7bit", map);
    }

    public SMIMESignedGenerator(String string, Map map) {
        this.defaultContentTransferEncoding = string;
        this.micAlgs = map;
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator<SignerInformation> iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._oldSigners.add(iterator.next());
        }
    }

    public void addSignerInfoGenerator(SignerInfoGenerator signerInfoGenerator) {
        this.signerInfoGens.add(signerInfoGenerator);
    }

    public void addCertificates(Store store) {
        this.certStores.add(store);
    }

    public void addCRLs(Store store) {
        this.crlStores.add(store);
    }

    public void addAttributeCertificates(Store store) {
        this.attrCertStores.add(store);
    }

    private void addHashHeader(StringBuffer stringBuffer, List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = object instanceof SignerInformation ? ((SignerInformation)object).getDigestAlgorithmID().getAlgorithm() : ((SignerInfoGenerator)object).getDigestAlgorithm().getAlgorithm();
            String string = (String)this.micAlgs.get(aSN1ObjectIdentifier);
            if (string == null) {
                treeSet.add("unknown");
                continue;
            }
            treeSet.add(string);
        }
        for (String string : treeSet) {
            if (n == 0) {
                if (treeSet.size() != 1) {
                    stringBuffer.append("; micalg=\"");
                } else {
                    stringBuffer.append("; micalg=");
                }
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            ++n;
        }
        if (n != 0 && treeSet.size() != 1) {
            stringBuffer.append('\"');
        }
    }

    private MimeMultipart make(MimeBodyPart mimeBodyPart) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentSigner(mimeBodyPart, false), DETACHED_SIGNATURE_TYPE);
            mimeBodyPart2.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer stringBuffer = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList arrayList = new ArrayList(this._signers);
            arrayList.addAll(this._oldSigners);
            arrayList.addAll(this.signerInfoGens);
            this.addHashHeader(stringBuffer, arrayList);
            MimeMultipart mimeMultipart = new MimeMultipart(stringBuffer.toString());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            return mimeMultipart;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    private MimeBodyPart makeEncapsulated(MimeBodyPart mimeBodyPart) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentSigner(mimeBodyPart, true), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)messagingException));
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }

    public MimeMultipart generate(MimeBodyPart mimeBodyPart) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart));
    }

    public MimeMultipart generate(MimeMessage mimeMessage) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart mimeBodyPart) throws SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(mimeBodyPart));
    }

    public MimeBodyPart generateEncapsulated(MimeMessage mimeMessage) throws SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.makeEncapsulated(this.makeContentBodyPart(mimeMessage));
    }

    public MimeBodyPart generateCertificateManagement() throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)new ContentSigner(null, true), CERTIFICATE_MANAGEMENT_CONTENT);
            mimeBodyPart.addHeader("Content-Type", CERTIFICATE_MANAGEMENT_CONTENT);
            mimeBodyPart.addHeader("Content-Disposition", "attachment; filename=\"smime.p7c\"");
            mimeBodyPart.addHeader("Content-Description", "S/MIME Certificate Management Message");
            mimeBodyPart.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)messagingException));
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    CommandMap.setDefaultCommandMap(SMIMESignedGenerator.addCommands((MailcapCommandMap)commandMap));
                }
                return null;
            }
        });
        HashMap<ASN1ObjectIdentifier, String> hashMap = new HashMap<ASN1ObjectIdentifier, String>();
        hashMap.put(CMSAlgorithm.MD5, "md5");
        hashMap.put(CMSAlgorithm.SHA1, "sha-1");
        hashMap.put(CMSAlgorithm.SHA224, "sha-224");
        hashMap.put(CMSAlgorithm.SHA256, "sha-256");
        hashMap.put(CMSAlgorithm.SHA384, "sha-384");
        hashMap.put(CMSAlgorithm.SHA512, "sha-512");
        hashMap.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        hashMap.put(CMSAlgorithm.GOST3411_2012_256, "gostr3411-2012-256");
        hashMap.put(CMSAlgorithm.GOST3411_2012_512, "gostr3411-2012-512");
        RFC5751_MICALGS = Collections.unmodifiableMap(hashMap);
        HashMap<ASN1ObjectIdentifier, String> hashMap2 = new HashMap<ASN1ObjectIdentifier, String>();
        hashMap2.put(CMSAlgorithm.MD5, "md5");
        hashMap2.put(CMSAlgorithm.SHA1, "sha1");
        hashMap2.put(CMSAlgorithm.SHA224, "sha224");
        hashMap2.put(CMSAlgorithm.SHA256, "sha256");
        hashMap2.put(CMSAlgorithm.SHA384, "sha384");
        hashMap2.put(CMSAlgorithm.SHA512, "sha512");
        hashMap2.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        hashMap2.put(CMSAlgorithm.GOST3411_2012_256, "gostr3411-2012-256");
        hashMap2.put(CMSAlgorithm.GOST3411_2012_512, "gostr3411-2012-512");
        RFC3851_MICALGS = Collections.unmodifiableMap(hashMap2);
        STANDARD_MICALGS = RFC5751_MICALGS;
    }

    private class ContentSigner
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart content;
        private final boolean encapsulate;
        private final boolean noProvider;

        ContentSigner(MimeBodyPart mimeBodyPart, boolean bl) {
            this.content = mimeBodyPart;
            this.encapsulate = bl;
            this.noProvider = true;
        }

        protected CMSSignedDataStreamGenerator getGenerator() throws CMSException {
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            Iterator iterator = SMIMESignedGenerator.this.certStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCertificates((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.crlStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCRLs((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.attrCertStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addAttributeCertificates((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.signerInfoGens.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addSignerInfoGenerator((SignerInfoGenerator)iterator.next());
            }
            cMSSignedDataStreamGenerator.addSigners(new SignerInformationStore(SMIMESignedGenerator.this._oldSigners));
            return cMSSignedDataStreamGenerator;
        }

        private void writeBodyPart(OutputStream outputStream, MimeBodyPart mimeBodyPart) throws IOException, MessagingException {
            if (SMIMEUtil.isMultipartContent((Part)mimeBodyPart)) {
                Object object = mimeBodyPart.getContent();
                Object object2 = object instanceof Multipart ? (Multipart)object : new MimeMultipart(mimeBodyPart.getDataHandler().getDataSource());
                ContentType contentType2 = new ContentType(object2.getContentType());
                String string = "--" + contentType2.getParameter("boundary");
                SMIMEUtil.LineOutputStream lineOutputStream = new SMIMEUtil.LineOutputStream(outputStream);
                Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    lineOutputStream.writeln((String)enumeration.nextElement());
                }
                lineOutputStream.writeln();
                SMIMEUtil.outputPreamble(lineOutputStream, mimeBodyPart, string);
                for (int i = 0; i < object2.getCount(); ++i) {
                    lineOutputStream.writeln(string);
                    this.writeBodyPart(outputStream, (MimeBodyPart)object2.getBodyPart(i));
                    lineOutputStream.writeln();
                }
                lineOutputStream.writeln(string + "--");
            } else {
                if (SMIMEUtil.isCanonicalisationRequired(mimeBodyPart, SMIMESignedGenerator.this.defaultContentTransferEncoding)) {
                    outputStream = new CRLFOutputStream(outputStream);
                }
                mimeBodyPart.writeTo(outputStream);
            }
        }

        public void write(OutputStream outputStream) throws IOException {
            try {
                CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = this.getGenerator();
                OutputStream outputStream2 = cMSSignedDataStreamGenerator.open(outputStream, this.encapsulate);
                if (this.content != null) {
                    if (!this.encapsulate) {
                        this.writeBodyPart(outputStream2, this.content);
                    } else {
                        CommandMap commandMap = CommandMap.getDefaultCommandMap();
                        if (commandMap instanceof MailcapCommandMap) {
                            this.content.getDataHandler().setCommandMap(SMIMESignedGenerator.addCommands((MailcapCommandMap)commandMap));
                        }
                        this.content.writeTo(outputStream2);
                    }
                }
                outputStream2.close();
                SMIMESignedGenerator.this._digests = cMSSignedDataStreamGenerator.getGeneratedDigests();
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.toString());
            }
            catch (CMSException cMSException) {
                throw new IOException(cMSException.toString());
            }
        }
    }
}

