/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph.utils;

import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.scilab.modules.graph.view.SupportedLabelType;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MathMLRenderUtils {
    private static Map<String, JMathComponent> generatedMathMLComponents = new WeakHashMap<String, JMathComponent>();

    public static Component getMathMLComponent(String string) throws SAXException {
        String string2 = SupportedLabelType.MathML.escape(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        JMathComponent jMathComponent = generatedMathMLComponents.get(string);
        if (jMathComponent == null) {
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
                jMathComponent = new JMathComponent();
                jMathComponent.setDocument(document.getFirstChild());
                generatedMathMLComponents.put(string, jMathComponent);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return jMathComponent;
    }

    private MathMLRenderUtils() {
    }
}

