/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graph;

import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import org.scilab.modules.graph.ScilabCanvas;
import org.scilab.modules.graph.ScilabGraph;

public class ScilabComponent
extends mxGraphComponent {
    private static final Color MASK_COLOR = new Color(240, 240, 240, 100);
    private static final double SCALE_MULTIPLIER = 1.1;

    public ScilabComponent(ScilabGraph scilabGraph) {
        super((mxGraph)scilabGraph);
    }

    protected mxGraphComponent.mxGraphControl createGraphControl() {
        return new ScilabGraphControl();
    }

    public ScilabCanvas createCanvas() {
        return new ScilabCanvas();
    }

    public void zoomAndCenterToCells(Object[] objectArray) {
        mxRectangle mxRectangle2 = this.zoomBounds(objectArray);
        Dimension dimension = this.getViewport().getSize();
        double d = dimension.getHeight() / mxRectangle2.getHeight();
        double d2 = dimension.getWidth() / mxRectangle2.getWidth();
        double d3 = d > 1.0 ? (d2 > 1.0 ? Math.min(d, d2) : d2) : (d2 > 1.0 ? d : Math.min(d, d2));
        if (Math.abs(1.0 - d3) < 0.2) {
            this.getGraphControl().scrollRectToVisible(this.zoomBounds(objectArray).getRectangle(), true);
            return;
        }
        this.zoom(d3 / 1.1);
        this.getGraphControl().scrollRectToVisible(this.zoomBounds(objectArray).getRectangle(), true);
    }

    private final mxRectangle zoomBounds(Object[] objectArray) {
        Object[] objectArray2 = objectArray == null || objectArray.length == 0 ? this.graph.getChildCells(this.graph.getDefaultParent()) : objectArray;
        mxRectangle mxRectangle2 = this.getChildrenBounds(objectArray2);
        return mxRectangle2;
    }

    private mxRectangle getChildrenBounds(Object[] objectArray) {
        mxRectangle mxRectangle2 = null;
        if (objectArray != null && objectArray.length > 0) {
            mxGraphView mxGraphView2 = this.graph.getView();
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!mxIGraphModel2.isVertex(objectArray[i]) && !mxIGraphModel2.isEdge(objectArray[i])) continue;
                mxICell mxICell2 = (mxICell)objectArray[i];
                int n = mxICell2.getChildCount();
                for (int j = 0; j < n; ++j) {
                    mxICell mxICell3 = mxICell2.getChildAt(j);
                    mxRectangle2 = this.updateRectangle(mxRectangle2, mxGraphView2, mxICell3);
                }
                mxRectangle2 = this.updateRectangle(mxRectangle2, mxGraphView2, mxICell2);
            }
        }
        return mxRectangle2;
    }

    private mxRectangle updateRectangle(mxRectangle mxRectangle2, mxGraphView mxGraphView2, mxICell mxICell2) {
        mxCellState mxCellState2 = mxGraphView2.getState((Object)mxICell2);
        mxRectangle mxRectangle3 = mxRectangle2;
        if (mxCellState2 != null) {
            if (mxRectangle3 == null) {
                mxRectangle3 = new mxRectangle((mxRectangle)mxCellState2);
            } else {
                mxRectangle3.add((mxRectangle)mxCellState2);
            }
        }
        return mxRectangle3;
    }

    protected void createHandlers() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        super.createHandlers();
    }

    public class ScilabGraphControl
    extends mxGraphComponent.mxGraphControl {
        public ScilabGraphControl() {
            super((mxGraphComponent)ScilabComponent.this);
            ScilabComponent.this.addListener("afterPaint", new mxEventSource.mxIEventListener(){

                public void invoke(Object object, mxEventObject mxEventObject2) {
                    Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                    if (ScilabComponent.this.getGraph().isCellsLocked()) {
                        graphics.setColor(MASK_COLOR);
                        Dimension dimension = ScilabComponent.this.getGraphControl().getSize();
                        graphics.fillRect(0, 0, dimension.width, dimension.height);
                    }
                }
            });
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (!ScilabComponent.this.getGraph().isCellsLocked()) {
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }
}

