/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.modelica;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.modules.xcos.modelica.ModelicaMessages;
import org.scilab.modules.xcos.modelica.model.ModelicaValue;
import org.scilab.modules.xcos.modelica.model.Terminal;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TerminalAccessor {
    NAME(ModelicaMessages.NAME, (Class)String.class, false){

        @Override
        protected Object getData(Terminal terminal) {
            return terminal.getName();
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.setName(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    ID(ModelicaMessages.ID, (Class)String.class, false){

        @Override
        protected Object getData(Terminal terminal) {
            return terminal.getId();
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.setId(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    KIND(ModelicaMessages.KIND, (Class)String.class, false){

        @Override
        protected Object getData(Terminal terminal) {
            return terminal.getKind();
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.setKind(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    FIXED(ModelicaMessages.FIXED, (Class)Boolean.class, false){

        @Override
        protected Object getData(Terminal terminal) {
            if (terminal.getFixed() == null) {
                terminal.setFixed(new ModelicaValue());
            }
            if (terminal.getFixed().getValue().isEmpty()) {
                return false;
            }
            String string = terminal.getFixed().getValue();
            return Boolean.valueOf(string);
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.getFixed().setValue(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    INITIAL(ModelicaMessages.INITIAL, (Class)Double.class, true){

        @Override
        protected Object getData(Terminal terminal) {
            if (terminal.getInitialValue() == null) {
                terminal.setInitialValue(new ModelicaValue());
            }
            if (terminal.getInitialValue().getValue().isEmpty()) {
                return 0.0;
            }
            String string = terminal.getInitialValue().getValue();
            return Double.valueOf(string);
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.getInitialValue().setValue(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    WEIGHT(ModelicaMessages.WEIGHT, (Class)Double.class, true){

        @Override
        protected Object getData(Terminal terminal) {
            if (terminal.getWeight() == null) {
                terminal.setWeight(new ModelicaValue());
            }
            if (terminal.getWeight().getValue().isEmpty()) {
                Boolean bl = (Boolean)6.getData(FIXED, terminal);
                Double d = bl != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
                return d;
            }
            String string = terminal.getWeight().getValue();
            return Double.valueOf(string);
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.getWeight().setValue(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    COMMENT(ModelicaMessages.COMMENT, (Class)String.class, true){

        @Override
        protected Object getData(Terminal terminal) {
            if (terminal.getComment() == null) {
                terminal.setComment(new ModelicaValue());
            }
            return terminal.getComment().getValue();
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Object object2 = this.getData(terminal);
            terminal.getComment().setValue(object.toString());
            this.firePropertyChange(terminal, object2, object);
        }
    }
    ,
    SELECTED(ModelicaMessages.SELECTED, (Class)Boolean.class, true){
        private static final String TRUE = "y";
        private static final String FALSE = "n";

        @Override
        protected Boolean getData(Terminal terminal) {
            if (terminal.getSelected() == null) {
                terminal.setSelected(new ModelicaValue());
            }
            return TRUE.equals(terminal.getSelected().getValue());
        }

        @Override
        public void setData(Object object, Terminal terminal) {
            Boolean bl = this.getData(terminal);
            String string = (Boolean)object != false ? TRUE : FALSE;
            terminal.getSelected().setValue(string);
            this.firePropertyChange(terminal, bl, object);
        }
    };

    private static final String VARIABLE = "variable";
    private static final String FIXED_PARAMETER = "fixed_parameter";
    private static ChangeSupport pcs;
    private String name;
    private Class<?> klass;
    private boolean editable;

    private TerminalAccessor(String string2, Class<?> clazz, boolean bl) {
        this.name = string2;
        this.klass = clazz;
        this.editable = bl;
    }

    public static <T> T getData(TerminalAccessor terminalAccessor, Terminal terminal) {
        return (T)terminalAccessor.getData(terminal);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public boolean isEditable() {
        return this.editable;
    }

    protected abstract Object getData(Terminal var1);

    public abstract void setData(Object var1, Terminal var2);

    protected void firePropertyChange(Terminal terminal, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        pcs.fireChangeEvent(this, new ChangeEvent(this, terminal, object, object2));
    }

    public void addChangeListener(ChangeListener changeListener) {
        pcs.addChangeListener(this, changeListener);
    }

    static {
        pcs = new ChangeSupport();
        WEIGHT.addChangeListener(new ChangeListener(){

            @Override
            public void change(ChangeEvent changeEvent) {
                Double d = (Double)TerminalAccessor.getData(INITIAL, changeEvent.getTerminal());
            }
        });
    }

    public static class ChangeSupport {
        private final Map<TerminalAccessor, List<ChangeListener>> listeners = new HashMap<TerminalAccessor, List<ChangeListener>>();

        public void addChangeListener(TerminalAccessor terminalAccessor, ChangeListener changeListener) {
            if (!this.listeners.containsKey((Object)terminalAccessor)) {
                this.listeners.put(terminalAccessor, new ArrayList());
            }
            List<ChangeListener> list = this.listeners.get((Object)terminalAccessor);
            list.add(changeListener);
        }

        public void removeChangeListener(TerminalAccessor terminalAccessor, ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners.get((Object)terminalAccessor);
            if (list != null) {
                list.remove(changeListener);
            }
        }

        protected void fireChangeEvent(TerminalAccessor terminalAccessor, ChangeEvent changeEvent) {
            if (this.listeners.containsKey((Object)terminalAccessor)) {
                for (ChangeListener changeListener : this.listeners.get((Object)terminalAccessor)) {
                    changeListener.change(changeEvent);
                }
            }
        }
    }

    public static class ChangeEvent
    extends EventObject {
        private final Terminal terminal;
        private final Object oldData;
        private final Object newData;

        public ChangeEvent(TerminalAccessor terminalAccessor, Terminal terminal, Object object, Object object2) {
            super((Object)terminalAccessor);
            this.terminal = terminal;
            this.oldData = object;
            this.newData = object2;
        }

        public Terminal getTerminal() {
            return this.terminal;
        }

        public Object getOldData() {
            return this.oldData;
        }

        public Object getNewData() {
            return this.newData;
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void change(ChangeEvent var1);
    }
}

