/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.io.scicos;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.scilab.modules.action_binding.highlevel.ScilabInterpreterManagement;
import org.scilab.modules.javasci.JavasciException;
import org.scilab.modules.javasci.Scilab;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.io.scicos.Handler;

public class ScilabDirectHandler
implements Handler {
    public static final String CONTEXT = "context";
    public static final String SCS_M = "scs_m";
    public static final String BLK = "blk";
    private static final Logger LOG = Logger.getLogger(ScilabDirectHandler.class.getPackage().getName());
    private static final ScilabDirectHandler INSTANCE = new ScilabDirectHandler();
    private final Semaphore lock = new Semaphore(1, true);

    private ScilabDirectHandler() {
    }

    public static ScilabDirectHandler acquire() {
        LOG.finest("lock request");
        try {
            boolean bl = ScilabDirectHandler.INSTANCE.lock.tryAcquire(0L, TimeUnit.SECONDS);
            if (!bl) {
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        LOG.finest("lock acquired");
        return INSTANCE;
    }

    public void release() {
        LOG.finest("lock release");
        ScilabDirectHandler.INSTANCE.lock.release();
    }

    @Override
    public synchronized Map<String, ScilabType> readContext() {
        ScilabType scilabType;
        ScilabType scilabType2;
        LOG.entering("ScilabDirectHandler", "readContext");
        HashMap<String, ScilabType> hashMap = new HashMap<String, ScilabType>();
        try {
            scilabType2 = Scilab.getInCurrentScilabSession((String)"context_names");
            scilabType = Scilab.getInCurrentScilabSession((String)"context_values");
        }
        catch (JavasciException javasciException) {
            throw new RuntimeException(javasciException);
        }
        if (!(scilabType2 instanceof ScilabString) || !(scilabType instanceof ScilabList)) {
            LOG.finer("data unavailable");
            return hashMap;
        }
        ScilabString scilabString = (ScilabString)scilabType2;
        ScilabList scilabList = (ScilabList)scilabType;
        LOG.finer("data available");
        for (int i = 0; i < Math.min(scilabString.getWidth(), scilabList.size()); ++i) {
            hashMap.put(scilabString.getData()[0][i], (ScilabType)scilabList.get(i));
        }
        LOG.exiting("ScilabDirectHandler", "readContext");
        return hashMap;
    }

    @Override
    public void writeContext(String[] stringArray) {
        LOG.entering("ScilabDirectHandler", "writeContext");
        try {
            Scilab.putInCurrentScilabSession((String)CONTEXT, (ScilabType)new ScilabString(stringArray));
        }
        catch (JavasciException javasciException) {
            throw new RuntimeException(javasciException);
        }
        LOG.exiting("ScilabDirectHandler", "writeContext");
    }

    public Map<String, ScilabType> evaluateContext(String[] stringArray) {
        LOG.entering("ScilabDirectHandler", "evaluateContext");
        Map<String, ScilabType> map = Collections.emptyMap();
        try {
            this.writeContext(stringArray);
            ScilabInterpreterManagement.synchronousScilabExec((String)"context = script2var(context, struct()); context_names = fieldnames(context)'; context_values = list(); for i=1:size(context_names, '*');    context_values(i) = context(context_names(i)); end; ");
            map = this.readContext();
        }
        catch (ScilabInterpreterManagement.InterpreterException interpreterException) {
            LOG.warning("Unable to evaluate the context");
            interpreterException.printStackTrace();
        }
        LOG.exiting("ScilabDirectHandler", "evaluateContext");
        return map;
    }
}

