/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph.swing.handler;

import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxConnectPreview;
import com.mxgraph.swing.handler.mxConnectionHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.graph.swing.GraphComponent;
import org.scilab.modules.xcos.graph.swing.handler.ConnectPreview;

public class ConnectionHandler
extends mxConnectionHandler {
    private boolean multiPointLinkStarted;

    public ConnectionHandler(GraphComponent graphComponent) {
        super((mxGraphComponent)graphComponent);
        this.marker = new mxCellMarker((mxGraphComponent)graphComponent){

            protected Object getCell(MouseEvent mouseEvent) {
                Object object = super.getCell(mouseEvent);
                if (ConnectionHandler.this.isConnecting()) {
                    if (ConnectionHandler.this.source != null) {
                        object = this.getFirstValidPort(object);
                        ConnectionHandler.this.error = ConnectionHandler.this.validateConnection(ConnectionHandler.this.source.getCell(), object);
                        if (ConnectionHandler.this.error != null && ConnectionHandler.this.error.length() == 0) {
                            object = null;
                            if (ConnectionHandler.this.createTarget) {
                                ConnectionHandler.this.error = null;
                            }
                        }
                    }
                } else if (!ConnectionHandler.this.isValidSource(object)) {
                    object = null;
                }
                return object;
            }

            protected boolean isValidState(mxCellState mxCellState2) {
                if (ConnectionHandler.this.isConnecting()) {
                    return ConnectionHandler.this.error == null;
                }
                return super.isValidState(mxCellState2);
            }

            protected Color getMarkerColor(MouseEvent mouseEvent, mxCellState mxCellState2, boolean bl) {
                return ConnectionHandler.this.isHighlighting() || ConnectionHandler.this.isConnecting() ? super.getMarkerColor(mouseEvent, mxCellState2, bl) : null;
            }

            protected boolean intersects(mxCellState mxCellState2, MouseEvent mouseEvent) {
                if (!ConnectionHandler.this.isHighlighting() || ConnectionHandler.this.isConnecting()) {
                    return true;
                }
                return super.intersects(mxCellState2, mouseEvent);
            }

            private Object getFirstValidPort(Object object) {
                if (!(object instanceof BasicBlock)) {
                    return object;
                }
                BasicBlock basicBlock = (BasicBlock)object;
                for (int i = 0; i < basicBlock.getChildCount(); ++i) {
                    mxICell mxICell2 = basicBlock.getChildAt(i);
                    String string = ConnectionHandler.this.validateConnection(ConnectionHandler.this.source.getCell(), mxICell2);
                    if (string != null) continue;
                    return mxICell2;
                }
                return object;
            }

            public void reset() {
                if (this.markedState != null) {
                    this.graphComponent.getGraph().addSelectionCell(this.markedState.getCell());
                }
                super.reset();
            }
        };
    }

    protected mxConnectPreview createConnectPreview() {
        return new ConnectPreview((GraphComponent)this.graphComponent);
    }

    protected void setResetEnable(boolean bl) {
        mxIGraphModel mxIGraphModel2 = this.graphComponent.getGraph().getModel();
        if (bl) {
            mxIGraphModel2.addListener("change", this.resetHandler);
        } else {
            mxIGraphModel2.removeListener(this.resetHandler, "change");
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = this.error != null && this.error.isEmpty() && !mouseEvent.isConsumed();
        boolean bl3 = bl = this.first != null && this.connectPreview.isActive() && !this.marker.hasValidState();
        if (bl2 && bl) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = mxGraph2.snap((double)mouseEvent.getX());
            double d2 = mxGraph2.snap((double)mouseEvent.getY());
            mxICell mxICell2 = (mxICell)this.connectPreview.getPreviewState().getCell();
            ArrayList<mxPoint> arrayList = mxICell2.getGeometry().getPoints();
            if (arrayList == null) {
                arrayList = new ArrayList<mxPoint>();
                mxICell2.getGeometry().setPoints(arrayList);
            }
            mxPoint mxPoint2 = mxGraph2.getView().getTranslate();
            double d3 = mxGraph2.getView().getScale();
            arrayList.add(new mxPoint(mxGraph2.snap(d / d3 - mxPoint2.getX()), mxGraph2.snap(d2 / d3 - mxPoint2.getY())));
            this.connectPreview.update(mouseEvent, null, d, d2);
            this.multiPointLinkStarted = true;
            mouseEvent.consume();
        } else {
            if (this.marker.hasValidState() && this.connectPreview.getPreviewState() != null) {
                mxGraph mxGraph3 = this.graphComponent.getGraph();
                double d = mxGraph3.snap((double)mouseEvent.getX());
                double d4 = mxGraph3.snap((double)mouseEvent.getY());
                mxICell mxICell3 = (mxICell)this.connectPreview.getPreviewState().getCell();
                mxICell3.setGeometry(mxICell3.getGeometry());
            }
            this.multiPointLinkStarted = false;
            super.mouseReleased(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.multiPointLinkStarted) {
            this.mouseDragged(mouseEvent);
        } else {
            super.mouseMoved(mouseEvent);
        }
    }

    public void start(MouseEvent mouseEvent, mxCellState mxCellState2) {
        if (!this.multiPointLinkStarted) {
            super.start(mouseEvent, mxCellState2);
        }
    }
}

