/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.graph;

import com.mxgraph.model.mxGeometry;
import java.awt.Dimension;
import java.io.File;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Iterator;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.Kind;
import org.scilab.modules.xcos.block.BasicBlock;
import org.scilab.modules.xcos.block.SplitBlock;
import org.scilab.modules.xcos.block.TextBlock;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.io.XcosFileType;
import org.scilab.modules.xcos.link.BasicLink;
import org.scilab.modules.xcos.palette.view.PaletteComponent;
import org.scilab.modules.xcos.palette.view.PaletteManagerPanel;
import org.scilab.modules.xcos.utils.BlockPositioning;
import org.scilab.modules.xcos.utils.XcosConstants;

public class PaletteDiagram
extends XcosDiagram {
    private String name;
    private String fileName;
    private double windowWidth;

    public PaletteDiagram(long l) {
        super(new JavaController(), l, Kind.DIAGRAM, new UID().toString());
        this.setComponent(new PaletteComponent(this));
        this.setTitle(PaletteDiagram.class.getName());
        this.setCellsLocked(false);
        this.setGridVisible(false);
        this.setCellsDeletable(false);
        this.setCellsEditable(false);
        this.getAsComponent().setHorizontalScrollBarPolicy(31);
        this.getUndoManager().setEventsEnabled(false);
    }

    public boolean openDiagramAsPal(String string) {
        File file = new File(string);
        if (file.exists()) {
            Object object;
            Object object2;
            try {
                object2 = XcosFileType.findFileType(file);
                ((XcosFileType)((Object)object2)).load(string, this);
            }
            catch (Exception exception) {
                return false;
            }
            this.setName(file.getName());
            this.setFileName(file.getAbsolutePath());
            this.getRubberBand().setEnabled(false);
            object2 = new ArrayList();
            for (int i = 0; i < this.getModel().getChildCount(this.getDefaultParent()); ++i) {
                object = this.getModel().getChildAt(this.getDefaultParent(), i);
                if (!(object instanceof BasicLink) && !(object instanceof SplitBlock) && !(object instanceof TextBlock)) continue;
                object2.add(object);
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.getModel().remove(object);
            }
            return true;
        }
        return false;
    }

    public void updateDiagram(double d) {
        if (d == this.windowWidth) {
            return;
        }
        int n = PaletteManagerPanel.getCurrentSize().getBlockDimension().width + 5;
        int n2 = (int)(d / (double)n);
        int n3 = (int)(this.windowWidth / (double)n);
        if (n2 == n3) {
            return;
        }
        this.windowWidth = d;
        int n4 = 0;
        this.getModel().beginUpdate();
        for (int i = 0; i < this.getModel().getChildCount(this.getDefaultParent()); ++i) {
            Object object = this.getModel().getChildAt(this.getDefaultParent(), i);
            if (!(object instanceof BasicBlock)) continue;
            BasicBlock basicBlock = (BasicBlock)object;
            basicBlock.setGeometry(this.getNewBlockPosition(basicBlock.getGeometry(), n4));
            BlockPositioning.updateBlockView(this, basicBlock);
            ++n4;
        }
        this.getModel().endUpdate();
        this.refresh();
        this.setModified(false);
    }

    private mxGeometry getNewBlockPosition(mxGeometry mxGeometry2, int n) {
        XcosConstants.PaletteBlockSize paletteBlockSize = PaletteManagerPanel.getCurrentSize();
        Dimension dimension = paletteBlockSize.getBlockDimension();
        int n2 = dimension.width + 5;
        int n3 = dimension.height + 5;
        int n4 = (int)(this.windowWidth / (double)n2);
        if (n4 <= 0) {
            n4 = 1;
        }
        int n5 = n % n4;
        int n6 = n / n4;
        double d = mxGeometry2.getX();
        double d2 = mxGeometry2.getY();
        double d3 = mxGeometry2.getWidth();
        double d4 = mxGeometry2.getHeight();
        if (mxGeometry2.getWidth() > (double)paletteBlockSize.getMaxIconWidth() || mxGeometry2.getHeight() > (double)paletteBlockSize.getMaxIconHeight()) {
            double d5 = Math.min((double)paletteBlockSize.getMaxIconWidth() / d3, (double)paletteBlockSize.getMaxIconHeight() / d4);
            d3 *= d5;
            d4 *= d5;
        }
        d = n5 * n2;
        d2 = n6 * n3;
        return new mxGeometry(d += ((double)dimension.width - d3) / 2.0, d2 += ((double)dimension.height - d4) / 2.0, d3, d4);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isCellConnectable(Object object) {
        return false;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }
}

