/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.xcos.block.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.graph.ScilabComponent;
import org.scilab.modules.graph.ScilabGraph;
import org.scilab.modules.graph.actions.base.DefaultAction;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.types.ScilabDouble;
import org.scilab.modules.types.ScilabList;
import org.scilab.modules.types.ScilabString;
import org.scilab.modules.types.ScilabType;
import org.scilab.modules.xcos.Controller;
import org.scilab.modules.xcos.JavaController;
import org.scilab.modules.xcos.ObjectProperties;
import org.scilab.modules.xcos.VectorOfDouble;
import org.scilab.modules.xcos.Xcos;
import org.scilab.modules.xcos.block.SuperBlock;
import org.scilab.modules.xcos.graph.ScicosParameters;
import org.scilab.modules.xcos.graph.XcosDiagram;
import org.scilab.modules.xcos.graph.model.ScicosObjectOwner;
import org.scilab.modules.xcos.io.ScilabTypeCoder;
import org.scilab.modules.xcos.io.scicos.ScilabDirectHandler;
import org.scilab.modules.xcos.utils.XcosMessages;

public final class SuperblockMaskCustomizeAction
extends DefaultAction {
    public static final String NAME = XcosMessages.CUSTOMIZE;
    public static final String SMALL_ICON = "";
    public static final int MNEMONIC_KEY = 0;
    public static final int ACCELERATOR_KEY = 0;
    private static final String TERMINATE_EDIT_ON_FOCUS_LOST = "terminateEditOnFocusLost";

    public SuperblockMaskCustomizeAction(ScilabGraph scilabGraph) {
        super(scilabGraph);
    }

    public static MenuItem createMenu(ScilabGraph scilabGraph) {
        return SuperblockMaskCustomizeAction.createMenu((ScilabGraph)scilabGraph, SuperblockMaskCustomizeAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XcosDiagram xcosDiagram = (XcosDiagram)this.getGraph(actionEvent);
        ScilabComponent scilabComponent = (ScilabComponent)xcosDiagram.getAsComponent();
        if (scilabComponent.isEditing()) {
            return;
        }
        SuperBlock superBlock = (SuperBlock)xcosDiagram.getSelectionCell();
        JavaController javaController = new JavaController();
        CustomizeFrame customizeFrame = new CustomizeFrame(javaController, new ScicosParameters(Xcos.findRoot(xcosDiagram), new ScicosObjectOwner(javaController, superBlock.getUID(), superBlock.getKind())));
        CustomizeFrame.CustomizeFrameModel customizeFrameModel = customizeFrame.getController().getModel();
        customizeFrameModel.setBlock(superBlock);
        customizeFrameModel.importFromBlock();
        customizeFrame.setVisible(true);
    }

    private static class CustomizeFrame
    extends JFrame {
        private final CustomizeFrameControler controler;
        private JPanel buttonBlob;
        private JButton cancelButton;
        private JPanel customizeMainPanel;
        private JScrollPane customizeScrollPane;
        private JTabbedPane tabbedPane;
        private JTable defaultValueTable;
        private JPanel defaultValues;
        private JScrollPane defaultValuesScrollPane;
        private JButton delete;
        private JButton insert;
        private JPanel mainPanel;
        private JButton moveDown;
        private JButton moveUp;
        private JButton okButton;
        private JLabel rowLabel;
        private JPanel rowManagement;
        private JSpinner rowSpinner;
        private JPanel tableManagement;
        private JPanel validationPanel;
        private JTable varCustomizeTable;
        private JPanel varSettings;

        public CustomizeFrame(JavaController javaController, ScicosParameters scicosParameters) {
            this.setTitle(XcosMessages.MASK_TITLE);
            this.setDefaultCloseOperation(1);
            ImageIcon imageIcon = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
            this.setIconImage(imageIcon.getImage());
            this.controler = new CustomizeFrameControler(javaController, scicosParameters);
            this.initComponents();
        }

        public CustomizeFrameControler getController() {
            return this.controler;
        }

        private void initComponents() {
            this.mainPanel = new JPanel();
            this.varSettings = new JPanel();
            this.customizeMainPanel = new JPanel();
            this.customizeScrollPane = new JScrollPane();
            this.varCustomizeTable = new JTable();
            this.tableManagement = new JPanel();
            this.insert = new JButton();
            this.delete = new JButton();
            this.buttonBlob = new JPanel();
            this.moveUp = new JButton();
            this.moveDown = new JButton();
            this.rowManagement = new JPanel();
            this.rowLabel = new JLabel();
            this.rowSpinner = new JSpinner();
            this.validationPanel = new JPanel();
            this.okButton = new JButton();
            this.cancelButton = new JButton();
            this.setDefaultCloseOperation(2);
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.varSettings.setLayout(new BoxLayout(this.varSettings, 3));
            this.varCustomizeTable.setModel(this.controler.getModel().customizeTableModel);
            this.varCustomizeTable.putClientProperty(SuperblockMaskCustomizeAction.TERMINATE_EDIT_ON_FOCUS_LOST, Boolean.TRUE);
            this.customizeScrollPane.setViewportView(this.varCustomizeTable);
            this.varCustomizeTable.setAutoCreateRowSorter(true);
            this.varCustomizeTable.getModel().addTableModelListener(this.controler.updateButtonsSensibleForModifications);
            this.varCustomizeTable.getSelectionModel().addListSelectionListener(this.controler.updateButtonsSensibleForSelectionChange);
            this.customizeMainPanel.add(this.customizeScrollPane);
            this.tableManagement.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.tableManagement.setLayout(new GridLayout(5, 1));
            this.insert.setMnemonic('n');
            this.insert.setText(XcosMessages.MASK_INSERT);
            this.tableManagement.add(this.insert);
            this.insert.addActionListener(this.controler.insertActionListener);
            this.delete.setMnemonic('l');
            this.delete.setText(XcosMessages.MASK_DELETE);
            this.tableManagement.add(this.delete);
            this.delete.addActionListener(this.controler.deleteActionListener);
            this.tableManagement.add(this.buttonBlob);
            this.moveUp.setMnemonic('u');
            this.moveUp.setText(XcosMessages.MASK_MOVEUP);
            this.tableManagement.add(this.moveUp);
            this.moveUp.addActionListener(this.controler.moveUpActionListener);
            this.moveDown.setMnemonic('w');
            this.moveDown.setText(XcosMessages.MASK_MOVEDOWN);
            this.tableManagement.add(this.moveDown);
            this.moveDown.addActionListener(this.controler.moveDownActionListener);
            this.customizeMainPanel.add(this.tableManagement);
            this.varSettings.add(this.customizeMainPanel);
            this.rowLabel.setText(XcosMessages.MASK_ROWS + " :");
            this.rowManagement.add(this.rowLabel);
            this.rowSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            this.rowSpinner.setEditor(new JSpinner.NumberEditor(this.rowSpinner, "######0"));
            this.rowSpinner.setValue(this.varCustomizeTable.getModel().getRowCount());
            this.rowManagement.add(this.rowSpinner);
            this.rowSpinner.addChangeListener(this.controler.rowSpinnerChangeListener);
            this.varSettings.add(this.rowManagement);
            this.mainPanel.add((Component)this.varSettings, "Center");
            this.okButton.setText(XcosMessages.OK);
            this.validationPanel.add(this.okButton);
            this.okButton.addActionListener(this.controler.okActionListener);
            this.cancelButton.setText(XcosMessages.CANCEL);
            this.validationPanel.add(this.cancelButton);
            this.cancelButton.addActionListener(this.controler.cancelActionListener);
            this.mainPanel.add((Component)this.validationPanel, "Last");
            this.add(this.mainPanel);
            this.pack();
            this.cancelButton.requestFocusInWindow();
            TableColumn tableColumn = this.varCustomizeTable.getColumnModel().getColumn(0);
            JComboBox<String> jComboBox = new JComboBox<String>();
            jComboBox.setEditable(true);
            Set<String> set = this.controler.context.keySet();
            for (String string : set) {
                jComboBox.addItem(string);
            }
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        }

        private class CustomizeFrameControler {
            private final CustomizeFrameModel model;
            private final ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomizeFrame.this.dispose();
                }
            };
            private final ActionListener okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomizeFrameControler.this.model.exportToBlock();
                    CustomizeFrame.this.dispose();
                }
            };
            private final ChangeListener rowSpinnerChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n;
                    int n2 = (Integer)CustomizeFrame.this.rowSpinner.getModel().getValue();
                    for (n = CustomizeFrame.this.varCustomizeTable.getRowCount(); n < n2; ++n) {
                        CustomizeFrameControler.this.insertActionListener.actionPerformed(new ActionEvent(this, -1, "ActionCommandKey"));
                    }
                    while (n > n2) {
                        CustomizeFrameControler.this.deleteActionListener.actionPerformed(new ActionEvent(this, -1, "ActionCommandKey"));
                        --n;
                    }
                }
            };
            private final ActionListener moveDownActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CustomizeFrame.this.varCustomizeTable.getSelectedRow();
                    CustomizeFrameControler.this.swapTableRow(CustomizeFrameControler.this.model.customizeTableModel, n, n + 1);
                    CustomizeFrame.this.varCustomizeTable.changeSelection(n + 1, CustomizeFrame.this.varCustomizeTable.getSelectedColumn(), false, false);
                }
            };
            private final ActionListener moveUpActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CustomizeFrame.this.varCustomizeTable.getSelectedRow();
                    CustomizeFrameControler.this.swapTableRow(CustomizeFrameControler.this.model.customizeTableModel, n, n - 1);
                    CustomizeFrame.this.varCustomizeTable.changeSelection(n - 1, CustomizeFrame.this.varCustomizeTable.getSelectedColumn(), false, false);
                }
            };
            private final ActionListener deleteActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = CustomizeFrame.this.varCustomizeTable.getSelectedRow();
                    int n2 = CustomizeFrame.this.varCustomizeTable.getRowCount();
                    if (n > 1) {
                        CustomizeFrameControler.this.model.customizeTableModel.removeRow(n);
                        CustomizeFrame.this.varCustomizeTable.changeSelection(n - 1, 1, false, false);
                    } else if (n2 > 1) {
                        CustomizeFrameControler.this.model.customizeTableModel.removeRow(n2 - 1);
                        CustomizeFrame.this.varCustomizeTable.changeSelection(n2 - 2, 1, false, false);
                    }
                }
            };
            private final ActionListener insertActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    Object object;
                    HashSet<String> hashSet = new HashSet<String>(CustomizeFrameControler.this.context.keySet());
                    hashSet.removeAll(CustomizeFrameControler.this.allocatedVariables);
                    if (hashSet.isEmpty()) {
                        object = "generatedVar0";
                        int n = 0;
                        while (CustomizeFrameControler.this.context.containsKey(object)) {
                            object = "generatedVar" + Integer.toString(n, 10);
                            ++n;
                        }
                        CustomizeFrameControler.this.context.put((String)object, (ScilabType)new ScilabDouble());
                        string = "[]";
                    } else {
                        object = hashSet.iterator().next();
                        string = CustomizeFrameControler.this.context.containsKey(object) ? CustomizeFrameControler.this.context.get(object).toString() : "[]";
                    }
                    CustomizeFrameControler.this.allocatedVariables.add((String)object);
                    CustomizeFrameControler.this.model.customizeTableModel.addRow(new Object[]{object, string, "Generated variable " + (String)object});
                    CustomizeFrame.this.varCustomizeTable.changeSelection(CustomizeFrameControler.this.model.customizeTableModel.getRowCount() - 1, 1, false, false);
                }
            };
            private final ListSelectionListener updateButtonsSensibleForSelectionChange = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = CustomizeFrame.this.varCustomizeTable.getSelectedRow();
                    int n2 = CustomizeFrame.this.varCustomizeTable.getRowCount();
                    boolean bl = n < 1;
                    boolean bl2 = n == 1;
                    boolean bl3 = n == n2 - 1;
                    CustomizeFrame.this.moveUp.setEnabled(!bl && !bl2);
                    CustomizeFrame.this.moveDown.setEnabled(!bl && !bl3);
                    CustomizeFrame.this.delete.setEnabled(!bl);
                }
            };
            private final TableModelListener updateButtonsSensibleForModifications = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    int n = CustomizeFrameControler.this.model.customizeTableModel.getRowCount();
                    CustomizeFrame.this.rowSpinner.setValue(n);
                }
            };
            private final Map<String, ScilabType> context;
            private final Set<String> allocatedVariables = new HashSet<String>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public CustomizeFrameControler(JavaController javaController, ScicosParameters scicosParameters) {
                this.model = new CustomizeFrameModel();
                Map<Object, Object> map = Collections.emptyMap();
                ScilabDirectHandler scilabDirectHandler = ScilabDirectHandler.acquire();
                try {
                    String[] stringArray = scicosParameters.getAllContext(javaController);
                    map = scilabDirectHandler.evaluateContext(stringArray);
                }
                finally {
                    this.context = map;
                    scilabDirectHandler.release();
                }
            }

            public CustomizeFrameModel getModel() {
                return this.model;
            }

            private void swapTableRow(DefaultTableModel defaultTableModel, int n, int n2) {
                Vector<Vector> vector = defaultTableModel.getDataVector();
                Vector vector2 = vector.get(n2);
                vector.set(n2, vector.get(n));
                vector.set(n, vector2);
            }
        }

        private class CustomizeFrameModel {
            private SuperBlock block;
            private final DefaultTableModel customizeTableModel = new DefaultTableModel(new Object[][]{{XcosMessages.MASK_WINTITLEVAR, XcosMessages.MASK_WINTITLE, XcosMessages.MASK_WINTITLE}}, new String[]{XcosMessages.MASK_VARNAME, XcosMessages.MASK_DEFAULTVALUES, XcosMessages.MASK_VARDESC}){
                private final Class<?>[] types;
                {
                    this.types = new Class[]{String.class, String.class, String.class};
                }

                @Override
                public Class<?> getColumnClass(int n) {
                    return this.types[n];
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    if (n == 0) {
                        return n2 == 1;
                    }
                    return true;
                }
            };

            protected CustomizeFrameModel() {
            }

            public void setBlock(SuperBlock superBlock) {
                this.block = superBlock;
            }

            public SuperBlock getBlock() {
                return this.block;
            }

            public void exportToBlock() {
                Object object;
                Vector<Vector> vector = this.customizeTableModel.getDataVector();
                int n = vector.size() - 1;
                String[][] stringArray = new String[n][1];
                String[][] stringArray2 = new String[n][1];
                String[][] stringArray3 = new String[n + 1][1];
                ScilabList scilabList = new ScilabList();
                stringArray3[0][0] = (String)((List)vector.get(0)).get(1);
                for (int i = 0; i < n; ++i) {
                    object = (List)vector.get(i + 1);
                    stringArray2[i][0] = (String)object.get(0);
                    stringArray[i][0] = (String)object.get(1);
                    stringArray3[i + 1][0] = (String)object.get(2);
                    scilabList.add((Object)new ScilabString("pol"));
                    scilabList.add((Object)new ScilabDouble(-1.0));
                }
                ScilabList scilabList2 = n == 0 ? new ScilabList(Arrays.asList(new ScilabDouble(), new ScilabList(Arrays.asList(new ScilabDouble(), new ScilabString(XcosMessages.MASK_DEFAULTWINDOWNAME), new ScilabList(Arrays.asList(new ScilabDouble())))))) : new ScilabList(Arrays.asList(new ScilabString(stringArray), new ScilabList(Arrays.asList(new ScilabString(stringArray2), new ScilabString(stringArray3), scilabList))));
                object = new JavaController();
                VectorOfDouble vectorOfDouble = new ScilabTypeCoder().var2vec((ScilabType)scilabList2);
                ((Controller)object).setObjectProperty(this.block.getUID(), this.block.getKind(), ObjectProperties.EXPRS, vectorOfDouble);
                if (Logger.getLogger(SuperblockMaskCustomizeAction.class.getName()).isLoggable(Level.FINEST)) {
                    Logger.getLogger(SuperblockMaskCustomizeAction.class.getName()).finest("exprs=" + String.valueOf(scilabList2));
                }
            }

            public void importFromBlock() {
                JavaController javaController = new JavaController();
                VectorOfDouble vectorOfDouble = new VectorOfDouble();
                javaController.getObjectProperty(this.block.getUID(), this.block.getKind(), ObjectProperties.EXPRS, vectorOfDouble);
                ScilabType scilabType = new ScilabTypeCoder().vec2var(vectorOfDouble);
                if (scilabType instanceof ScilabDouble) {
                    scilabType = new ScilabList(Arrays.asList(new ScilabDouble(), new ScilabList(Arrays.asList(new ScilabDouble(), new ScilabString(XcosMessages.MASK_DEFAULTWINDOWNAME), new ScilabList(Arrays.asList(new ScilabDouble()))))));
                }
                DefaultTableModel defaultTableModel = this.customizeTableModel;
                assert (scilabType instanceof ScilabList);
                ScilabList scilabList = (ScilabList)scilabType;
                assert (scilabList.get(0) instanceof ScilabDouble || scilabList.get(0) instanceof ScilabString);
                ScilabString scilabString = scilabList.get(0) instanceof ScilabDouble ? new ScilabString(SuperblockMaskCustomizeAction.SMALL_ICON) : (ScilabString)scilabList.get(0);
                assert (scilabList.get(1) instanceof ScilabList);
                ScilabList scilabList2 = (ScilabList)scilabList.get(1);
                assert (scilabList2.get(0) instanceof ScilabDouble || scilabList2.get(0) instanceof ScilabString);
                ScilabString scilabString2 = scilabList2.get(0) instanceof ScilabDouble ? new ScilabString() : (ScilabString)scilabList2.get(0);
                assert (scilabList2.get(1) instanceof ScilabString);
                ScilabString scilabString3 = (ScilabString)scilabList2.get(1);
                defaultTableModel.setValueAt(scilabString3.getData()[0][0], 0, 1);
                if (scilabString3.getHeight() >= scilabString3.getWidth()) {
                    for (int i = 1; i < scilabString3.getHeight(); ++i) {
                        defaultTableModel.addRow(new Object[]{scilabString2.getData()[i - 1][0], scilabString.getData()[i - 1][0], scilabString3.getData()[i][0]});
                    }
                } else {
                    for (int i = 1; i < scilabString3.getHeight(); ++i) {
                        defaultTableModel.addRow(new Object[]{scilabString2.getData()[0][i - 1], scilabString.getData()[0][i - 1], scilabString3.getData()[0][i]});
                    }
                }
            }
        }
    }
}

