/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.completion;

import com.artenum.rosetta.interfaces.core.CompletionItem;
import com.artenum.rosetta.interfaces.core.InputParsingManager;
import com.artenum.rosetta.interfaces.ui.CompletionWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.scilab.modules.completion.Completion;
import org.scilab.modules.completion.SciCompletionItemListCellRenderer;
import org.scilab.modules.localization.Messages;

public abstract class AbstractSciCompletionWindow
implements CompletionWindow,
KeyListener,
FocusListener,
MouseMotionListener,
MouseListener {
    private static final int WINDOW_WIDTH = 300;
    private static final int WINDOW_HEIGHT = 100;
    protected JPanel window;
    protected CompletionItemListModel model;
    protected JList listUI;
    protected JScrollPane scrollPane;
    protected InputParsingManager inputParsingManager;
    protected JComponent focusOutComponent;
    protected int currentCaretPosition;

    public abstract JTextComponent getTextComponent();

    public abstract List<CompletionItem> getCompletionItems();

    public void setFocusOut(JComponent jComponent) {
        this.focusOutComponent = jComponent;
    }

    public void setInputParsingManager(InputParsingManager inputParsingManager) {
        this.inputParsingManager = inputParsingManager;
    }

    public void setGraphicalContext(Component component) {
        this.model = new CompletionItemListModel();
        this.listUI = new JList(this.model);
        this.listUI.setCellRenderer(new SciCompletionItemListCellRenderer());
        this.scrollPane = new JScrollPane(this.listUI, 20, 30);
        JLabel jLabel = new JLabel("~", 0);
        jLabel.addMouseMotionListener(this);
        this.scrollPane.setCorner("LOWER_RIGHT_CORNER", jLabel);
        this.window = new JPanel(new BorderLayout());
        this.window.add((Component)this.scrollPane, "Center");
        this.window.setSize(new Dimension(300, 100));
        this.window.setCursor(new Cursor(0));
        this.listUI.getInputMap().clear();
        this.scrollPane.getInputMap().clear();
        this.listUI.addKeyListener(this);
        this.listUI.addFocusListener(this);
        this.listUI.addMouseListener(this);
        this.getTextComponent().add(this.window);
        this.setVisible(false);
    }

    public abstract void show(List<CompletionItem> var1, Point var2);

    public String getCompletionResult() {
        return ((CompletionItem)this.listUI.getSelectedValue()).getReturnValue();
    }

    public String getCompletionResultType() {
        return ((CompletionItem)this.listUI.getSelectedValue()).getType();
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public void setVisible(boolean bl) {
        this.window.setVisible(bl);
        if (!bl) {
            this.focusOutComponent.grabFocus();
        }
    }

    public void addCompletedWord(int n) {
        String string = this.inputParsingManager.getCommandLine();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String string4 = this.getCompletionResult();
        String string5 = this.getCompletionResultType();
        boolean bl = false;
        if (string5.equals(Messages.gettext((String)"File")) || string5.equals(Messages.gettext((String)"Directory"))) {
            bl = true;
        }
        String string6 = Completion.completelineforjava(string2, string4, bl, string3);
        this.inputParsingManager.reset();
        this.inputParsingManager.append(string6);
    }

    public void addCompletedWord(String string, int n) {
        String string2 = this.inputParsingManager.getCommandLine();
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n);
        String string5 = Completion.completelineforjava(string3, string, false, string4);
        this.inputParsingManager.reset();
        this.inputParsingManager.append(string5);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this.listUI.getModel().getSize() != 0) {
                this.addCompletedWord(this.currentCaretPosition);
            }
            this.setVisible(false);
            this.focusOutComponent.grabFocus();
        } else if (keyEvent.getKeyCode() == 27) {
            this.setVisible(false);
            this.focusOutComponent.grabFocus();
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.model.getSize() > 0) {
                this.listUI.setSelectedIndex(this.listUI.getSelectedIndex() % this.model.getSize());
            }
        } else if (keyEvent.getKeyCode() == 38) {
            if (this.model.getSize() > 0) {
                this.listUI.setSelectedIndex((this.model.getSize() + this.listUI.getSelectedIndex()) % this.model.getSize());
            }
        } else if (keyEvent.getKeyCode() == 8) {
            if (this.inputParsingManager.getPartLevel(this.inputParsingManager.getCompletionLevel()) != null) {
                this.inputParsingManager.backspace();
                Point point = this.inputParsingManager.getWindowCompletionLocation();
                this.show(this.getCompletionItems(), point);
                this.listUI.setSelectedIndex(0);
            } else {
                this.setVisible(false);
                this.focusOutComponent.grabFocus();
            }
        } else if (keyEvent.getKeyCode() != 9 && keyEvent.getKeyChar() != '\uffff') {
            this.inputParsingManager.append(String.valueOf(keyEvent.getKeyChar()));
            Point point = this.inputParsingManager.getWindowCompletionLocation();
            this.show(this.getCompletionItems(), point);
            this.listUI.setSelectedIndex(0);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.window.getLocationOnScreen();
        Point point2 = ((Component)mouseEvent.getSource()).getLocationOnScreen();
        point2.x += mouseEvent.getX();
        point2.y += mouseEvent.getY();
        point2.translate(-point.x, -point.y);
        this.window.setSize(point2.x, point2.y);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.model.getSize() > 0) {
            this.listUI.setSelectedIndex(this.listUI.getSelectedIndex() % this.model.getSize());
            if (mouseEvent.getClickCount() >= 2) {
                this.addCompletedWord(this.currentCaretPosition);
                this.setVisible(false);
                this.focusOutComponent.grabFocus();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.window.validate();
    }

    protected static class CompletionItemListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private List<CompletionItem> data = new ArrayList<CompletionItem>();
        private String filter;

        @Override
        public Object getElementAt(int n) {
            return this.data.get(n);
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        public void setFilter(String string) {
            this.filter = string == null || string != null && string.length() == 0 ? null : string;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public void updateData(List<CompletionItem> list) {
            this.data.clear();
            this.data.addAll(list);
            Collections.sort(this.data);
            this.setFilter(null);
        }
    }
}

