/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import org.cef.network.CefPostDataElement_N;

public abstract class CefPostDataElement {
    CefPostDataElement() {
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static final CefPostDataElement create() {
        return CefPostDataElement_N.createNative();
    }

    public abstract void dispose();

    public abstract boolean isReadOnly();

    public abstract void setToEmpty();

    public abstract void setToFile(String var1);

    public abstract void setToBytes(int var1, byte[] var2);

    public abstract Type getType();

    public abstract String getFile();

    public abstract int getBytesCount();

    public abstract int getBytes(int var1, byte[] var2);

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        int n = this.getBytesCount();
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[n];
        }
        boolean bl = false;
        if (string != null) {
            if (string.startsWith("text/")) {
                bl = true;
            } else if (string.startsWith("application/xml")) {
                bl = true;
            } else if (string.startsWith("application/xhtml")) {
                bl = true;
            } else if (string.startsWith("application/x-www-form-urlencoded")) {
                bl = true;
            }
        }
        Object object = "";
        if (this.getType() == Type.PDE_TYPE_BYTES) {
            int n2 = this.getBytes(byArray.length, byArray);
            object = (String)object + "    Content-Length: " + n + "\n";
            if (bl) {
                object = (String)object + "\n    " + new String(byArray);
            } else {
                for (int i = 0; i < n2; ++i) {
                    if (i % 40 == 0) {
                        object = (String)object + "\n    ";
                    }
                    object = (String)object + String.format("%02X", byArray[i]) + " ";
                }
            }
            object = (String)object + "\n";
        } else if (this.getType() == Type.PDE_TYPE_FILE) {
            object = (String)object + "\n    Bytes of file: " + this.getFile() + "\n";
        }
        return object;
    }

    public static enum Type {
        PDE_TYPE_EMPTY,
        PDE_TYPE_BYTES,
        PDE_TYPE_FILE,
        PDF_TYPE_NUM_VALUES;

    }
}

