/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.flexdock.docking.event.DockingEvent;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.xml.ScilabXMLUtilities;
import org.scilab.modules.gui.bridge.menuitem.SwingScilabMenuItem;
import org.scilab.modules.gui.bridge.tab.SwingScilabDockablePanel;
import org.scilab.modules.gui.bridge.tab.SwingScilabPanel;
import org.scilab.modules.gui.bridge.window.SwingScilabWindow;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.gui.menu.Menu;
import org.scilab.modules.gui.menu.ScilabMenu;
import org.scilab.modules.gui.menubar.MenuBar;
import org.scilab.modules.gui.menubar.ScilabMenuBar;
import org.scilab.modules.gui.menuitem.MenuItem;
import org.scilab.modules.gui.menuitem.ScilabMenuItem;
import org.scilab.modules.gui.tab.SimpleTab;
import org.scilab.modules.gui.tabfactory.AbstractScilabTabFactory;
import org.scilab.modules.gui.tabfactory.ScilabTabFactory;
import org.scilab.modules.gui.textbox.ScilabTextBox;
import org.scilab.modules.gui.textbox.TextBox;
import org.scilab.modules.gui.toolbar.ToolBar;
import org.scilab.modules.gui.utils.ClosingOperationsManager;
import org.scilab.modules.gui.utils.WindowsConfigurationManager;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.SearchManager;
import org.scilab.modules.scinotes.tabfactory.SearchInFilesTabFactory;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SearchFile
extends SwingScilabDockablePanel {
    public static final String SEARCHDONE = "SearchFile.SearchDone";
    private SwingScilabWindow parentWindow;
    private SciNotes editor;
    private MyBackgroundSearch mySearch;
    private JTree tree;

    public SearchFile(SciNotes sciNotes, String string) {
        super(SciNotesMessages.SEARCHINFILES, string == null ? UUID.randomUUID().toString() : string);
        this.editor = sciNotes;
        sciNotes.addSearchInFiles(this);
        ConfigSciNotesManager.saveSearchInFilesState(sciNotes.getPersistentId(), this.getPersistentId());
        this.initTab();
        this.restoreSearchFile();
        WindowsConfigurationManager.restorationFinished((SwingScilabDockablePanel)this);
    }

    public SearchFile(SciNotes sciNotes) {
        this(sciNotes, null);
    }

    public void setParentWindow() {
        this.parentWindow = SwingScilabWindow.createWindow((boolean)true);
        this.parentWindow.addTab((SwingScilabPanel)this);
        this.parentWindow.setVisible(true);
    }

    public SwingScilabWindow getParentWindow() {
        return this.parentWindow;
    }

    public SimpleTab getAsSimpleTab() {
        return this;
    }

    public void addInfoBar(TextBox textBox) {
        this.setInfoBar(textBox);
    }

    public void addMenuBar(MenuBar menuBar) {
        this.setMenuBar(menuBar);
    }

    public void addToolBar(ToolBar toolBar) {
        this.setToolBar(toolBar);
    }

    public void dockingComplete(DockingEvent dockingEvent) {
        super.dockingComplete(dockingEvent);
        this.changeToolBar();
    }

    public void changeToolBar() {
        SwingScilabWindow swingScilabWindow = (SwingScilabWindow)SwingUtilities.getAncestorOfClass(SwingScilabWindow.class, (Component)((Object)this));
        Set set = swingScilabWindow.getDockingPort().getDockables();
        for (SwingScilabDockablePanel swingScilabDockablePanel : set) {
            if (swingScilabDockablePanel != this.editor) continue;
            this.addToolBar(this.editor.getToolBar());
            break;
        }
    }

    public void closeSearchInFiles() {
        this.saveSearchFile();
        this.editor.removeSearchInFiles();
        this.editor = null;
        this.parentWindow = null;
    }

    public void undockingComplete(DockingEvent dockingEvent) {
        super.undockingComplete(dockingEvent);
        this.addToolBar(null);
    }

    public synchronized void setMyBackgroundSearch(MyBackgroundSearch myBackgroundSearch) {
        this.mySearch = myBackgroundSearch;
    }

    private synchronized void saveSearchFile() {
        if (this.mySearch != null) {
            try (FileWriter fileWriter = new FileWriter(ScilabConstants.SCIHOME.toString() + File.separator + this.getPersistentId() + ".xml");
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                bufferedWriter.append("<SearchResults editor=\"" + String.valueOf(this.editor.getUUID()) + "\"");
                bufferedWriter.append(" base=\"" + this.mySearch.base + "\"");
                bufferedWriter.append(" recursive=\"" + this.mySearch.recursive + "\"");
                bufferedWriter.append(" ignoreCR=\"" + this.mySearch.ignoreCR + "\"");
                bufferedWriter.append(" filePattern=\"" + ScilabXMLUtilities.getXMLString((String)this.mySearch.filePattern) + "\"");
                bufferedWriter.append(" fileCaseSensitive=\"" + this.mySearch.fileCaseSensitive + "\"");
                if (this.mySearch.wordPattern != null && !this.mySearch.wordPattern.isEmpty()) {
                    bufferedWriter.append(" wordPattern=\"" + ScilabXMLUtilities.getXMLString((String)this.mySearch.wordPattern) + "\"");
                }
                bufferedWriter.append(" wordCaseSensitive=\"" + this.mySearch.wordCaseSensitive + "\"");
                bufferedWriter.append(" wholeWord=\"" + this.mySearch.wholeWord + "\"");
                bufferedWriter.append(" regexp=\"" + this.mySearch.regexp + "\"");
                bufferedWriter.append(">\n");
                this.mySearch.getResults().toXML(bufferedWriter, 1);
                bufferedWriter.append("</SearchResults>");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void restoreSearchFile() {
        Document document;
        File file = new File(String.valueOf(ScilabConstants.SCIHOME) + File.separator + this.getPersistentId() + ".xml");
        if (file.exists() && (document = ScilabXMLUtilities.readDocument((String)file.getAbsolutePath())) != null) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Position");
            if (nodeList.getLength() == 0) {
                return;
            }
            SearchManager.MatchingPositions matchingPositions = new SearchManager.MatchingPositions((Element)nodeList.item(0));
            String string = element.getAttribute("base");
            boolean bl = Boolean.parseBoolean(element.getAttribute("recursive"));
            boolean bl2 = Boolean.parseBoolean(element.getAttribute("ignoreCR"));
            String string2 = element.getAttribute("filePattern").replaceAll("&quot;", "\"");
            boolean bl3 = Boolean.parseBoolean(element.getAttribute("fileCaseSensitive"));
            String string3 = element.getAttribute("filePattern").replaceAll("&quot;", "\"");
            boolean bl4 = Boolean.parseBoolean(element.getAttribute("wordCaseSensitive"));
            boolean bl5 = Boolean.parseBoolean(element.getAttribute("wholeWord"));
            boolean bl6 = Boolean.parseBoolean(element.getAttribute("regexp"));
            this.fillTab(matchingPositions, string, bl, bl2, string2, bl3, string3, bl4, bl5, bl6);
        }
    }

    public void fillTab(SearchManager.MatchingPositions matchingPositions, String string, boolean bl, boolean bl2, String string2, boolean bl3, String string3, boolean bl4, boolean bl5, boolean bl6) {
        Object object = string3 == null || string3.isEmpty() ? SciNotesMessages.SEARCHFILES : SciNotesMessages.SEARCHINFILES;
        object = (String)object + " " + SciNotesMessages.FILEPATTERN + ": " + string2;
        object = (String)object + ", " + SciNotesMessages.FILECASESENSITIVE + ": " + bl3;
        object = (String)object + ", " + SciNotesMessages.RECURSIVE + ": " + bl;
        if (string3 != null && !string3.isEmpty()) {
            object = (String)object + ", " + SciNotesMessages.LINEBYLINE + ": " + !bl2;
            object = bl6 ? (String)object + ", " + SciNotesMessages.REGEXPATTERN + ": " + string3 : (String)object + ", " + SciNotesMessages.WORD + ": " + string3;
            object = (String)object + ", " + SciNotesMessages.WORDCASESENSITIVE + ": " + bl4;
            object = (String)object + ", " + SciNotesMessages.WHOLE_WORD + ": " + bl5;
        }
        this.tree = SearchFile.getJTree(matchingPositions, this.editor, this.getInfoBar(), string, bl, bl2, string2, bl3, string3, bl4, bl5, bl6);
        this.setTitle((String)object);
        JScrollPane jScrollPane = new JScrollPane();
        this.setContentPane(jScrollPane);
        jScrollPane.setViewportView(this.tree);
        this.setVisible(true);
    }

    private void initTab() {
        TextBox textBox = ScilabTextBox.createTextBox();
        this.setWindowIcon("system-search");
        this.updateUI();
        CommonCallBack commonCallBack = new CommonCallBack(null){

            public void callBack() {
                ClosingOperationsManager.startClosingOperation((SwingScilabDockablePanel)SearchFile.this);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.callBack();
            }
        };
        this.setCallback(commonCallBack);
        MenuBar menuBar = ScilabMenuBar.createMenuBar();
        Menu menu = ScilabMenu.createMenu();
        menu.setText(SciNotesMessages.FILE);
        menu.setMnemonic(70);
        MenuItem menuItem = ScilabMenuItem.createMenuItem();
        menuItem.setCallback(commonCallBack);
        ((SwingScilabMenuItem)menuItem.getAsSimpleMenuItem()).setAccelerator(SciNotes.getActionKeys().get("scinotes-exit"));
        menuItem.setText(SciNotesMessages.EXIT);
        menu.add(menuItem);
        menuBar.add(menu);
        this.addMenuBar(menuBar);
        this.addInfoBar(textBox);
        this.setPreferredSize(new Dimension(650, 250));
    }

    public JTree getJTree() {
        return this.tree;
    }

    public static JTree getJTree(SearchManager.MatchingPositions matchingPositions, final SciNotes sciNotes, final TextBox textBox, String string, boolean bl, boolean bl2, String string2, boolean bl3, String string3, boolean bl4, boolean bl5, boolean bl6) {
        Serializable serializable;
        if (matchingPositions == null) {
            serializable = new ArrayList<SearchManager.MatchingPositions>();
            matchingPositions = new SearchManager.MatchingPositions(new File(string).getAbsolutePath(), (List<SearchManager.MatchingPositions>)((Object)serializable));
            matchingPositions.setRoot();
        }
        serializable = null;
        if (string3 != null && string3.length() != 0) {
            serializable = SearchManager.generatePattern(string3, bl4, bl5, bl6);
        }
        ArrayList<SearchManager.MatchingPositions> arrayList = serializable;
        matchingPositions.setRoot();
        final JTree jTree = new JTree(matchingPositions.toDefaultMutableTreeNode());
        MouseAdapter mouseAdapter = new MouseAdapter((Pattern)((Object)arrayList)){
            final /* synthetic */ Pattern val$p;
            {
                this.val$p = pattern;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 2) {
                    SearchFile.validNode(sciNotes, this.val$p, jTree.getPathForRow(n));
                }
            }
        };
        jTree.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "toggle");
        jTree.addKeyListener(new KeyAdapter((Pattern)((Object)arrayList)){
            final /* synthetic */ Pattern val$p;
            {
                this.val$p = pattern;
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n;
                if (keyEvent.getKeyChar() == '\n' && (n = jTree.getMinSelectionRow()) != -1) {
                    SearchFile.validNode(sciNotes, this.val$p, jTree.getPathForRow(n));
                }
            }
        });
        jTree.addMouseListener(mouseAdapter);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                SearchManager.Iconable iconable = (SearchManager.Iconable)defaultMutableTreeNode.getUserObject();
                this.setIcon(iconable.getIcon());
                return this;
            }
        };
        if (textBox != null) {
            jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                    if (object instanceof SearchManager.MatchingPositions) {
                        textBox.setText(((SearchManager.MatchingPositions)object).getFileName());
                    } else if (object instanceof SearchManager.Line) {
                        object = ((DefaultMutableTreeNode)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()).getUserObject();
                        textBox.setText(((SearchManager.MatchingPositions)object).getFileName());
                    }
                }
            });
        }
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setCellRenderer(defaultTreeCellRenderer);
        return jTree;
    }

    public static Object getSearchResultsWindow(JComponent jComponent, SciNotes sciNotes, String string, boolean bl, boolean bl2, String string2, boolean bl3, String string3, boolean bl4, boolean bl5, boolean bl6) {
        MyBackgroundSearch myBackgroundSearch = new MyBackgroundSearch(jComponent, sciNotes, string, bl, bl2, string2, bl3, string3, bl4, bl5, bl6);
        myBackgroundSearch.start();
        return myBackgroundSearch;
    }

    public static void stopSearch(Object object) {
        if (object != null && object instanceof MyBackgroundSearch) {
            ((MyBackgroundSearch)object).stop();
        }
    }

    public static boolean isDone(Object object) {
        if (object != null && object instanceof MyBackgroundSearch) {
            return ((MyBackgroundSearch)object).isDone();
        }
        return true;
    }

    private static void validNode(SciNotes sciNotes, final Pattern pattern, TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        int n = -1;
        String string = null;
        boolean bl = false;
        if (object instanceof SearchManager.MatchingPositions) {
            var8_8 = (SearchManager.MatchingPositions)object;
            n = 0;
            if (!((SearchManager.MatchingPositions)var8_8).isDirectory()) {
                string = ((SearchManager.MatchingPositions)var8_8).getFileName();
            }
        } else if (object instanceof SearchManager.Line) {
            var8_8 = (SearchManager.Line)object;
            n = ((SearchManager.Line)var8_8).getNumber();
            string = ((SearchManager.MatchingPositions)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject()).getFileName();
            bl = true;
        }
        if (string != null) {
            final boolean bl2 = !bl;
            final int n2 = n;
            if (n != -1) {
                sciNotes.openFile(string, 0, null);
                final ScilabEditorPane scilabEditorPane = sciNotes.getTextPane();
                if (scilabEditorPane.getName().equals(string)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            scilabEditorPane.highlightWords(pattern, bl2);
                            if (n2 != 0) {
                                scilabEditorPane.scrollTextToLineNumber(n2, false, false, true);
                            }
                        }
                    });
                }
            }
        }
    }

    static {
        ScilabTabFactory.getInstance().addTabFactory((AbstractScilabTabFactory)SearchInFilesTabFactory.getInstance());
    }

    private static class MyBackgroundSearch
    extends SearchManager.BackgroundSearch {
        SciNotes editor;
        JComponent component;
        String base;
        boolean recursive;
        boolean ignoreCR;
        String filePattern;
        boolean fileCaseSensitive;
        String wordPattern;
        boolean wordCaseSensitive;
        boolean wholeWord;
        boolean regexp;

        public MyBackgroundSearch(JComponent jComponent, SciNotes sciNotes, String string, boolean bl, boolean bl2, String string2, boolean bl3, String string3, boolean bl4, boolean bl5, boolean bl6) {
            this.component = jComponent;
            this.editor = sciNotes;
            this.base = string;
            this.recursive = bl;
            this.ignoreCR = bl2;
            this.filePattern = string2;
            this.fileCaseSensitive = bl3;
            this.wordPattern = string3;
            this.wordCaseSensitive = bl4;
            this.wholeWord = bl5;
            this.regexp = bl6;
        }

        public synchronized void start() {
            SearchManager.searchInFiles(this, this.base, this.recursive, this.ignoreCR, this.filePattern, this.fileCaseSensitive, this.wordPattern, this.wordCaseSensitive, this.wholeWord, this.regexp);
        }

        @Override
        public synchronized void stop() {
            super.stop();
            if (this.component != null) {
                this.component.firePropertyChange(SearchFile.SEARCHDONE, false, true);
            }
        }

        @Override
        public synchronized void done() {
            SearchFile searchFile;
            SearchManager.MatchingPositions matchingPositions = this.getResults();
            if (matchingPositions == null) {
                if (this.component != null) {
                    this.component.firePropertyChange(SearchFile.SEARCHDONE, false, true);
                }
                return;
            }
            SearchFile searchFile2 = this.editor.getSearchInFiles();
            if (searchFile2 == null) {
                this.editor.addSearchInFiles();
                searchFile = this.editor.getSearchInFiles();
            } else {
                searchFile = searchFile2;
            }
            searchFile.fillTab(matchingPositions, this.base, this.recursive, this.ignoreCR, this.filePattern, this.fileCaseSensitive, this.wordPattern, this.wordCaseSensitive, this.wholeWord, this.regexp);
            searchFile.setMyBackgroundSearch(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    searchFile.getJTree().addSelectionRow(0);
                    searchFile.getJTree().requestFocus();
                    long l = this.getElapsedTime();
                    searchFile.getInfoBar().setText(String.format(SciNotesMessages.ELAPSEDTIME, (double)l / 1000.0));
                }
            });
            if (this.component != null) {
                this.component.firePropertyChange(SearchFile.SEARCHDONE, false, true);
            }
        }
    }
}

