/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.utils;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabDocument;
import org.scilab.modules.scinotes.ScilabEditorPane;

public class DropFilesListener
implements DropTargetListener {
    private DropTarget dropTarget;
    private ScilabEditorPane pane;
    private int p0;
    private int p1;
    private Point previousPoint = new Point();
    private Point actualPoint = new Point();
    private int actualPos;
    private boolean enter;

    public DropFilesListener(ScilabEditorPane scilabEditorPane) {
        this.pane = scilabEditorPane;
        this.dropTarget = new DropTarget(scilabEditorPane, 3, this, true, null);
        this.dropTarget.setActive(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            int n = this.pane.getSelectionStart();
            int n2 = this.pane.getSelectionEnd();
            if (n2 != n) {
                this.p1 = n2;
                this.p0 = n;
            }
            this.enter = true;
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.enter) {
            int n = this.actualPoint.y - this.previousPoint.y;
            ScilabDocument scilabDocument = (ScilabDocument)this.pane.getDocument();
            Element element = scilabDocument.getDefaultRootElement();
            int n2 = element.getElementIndex(this.actualPos);
            int n3 = Math.max(0, n2 + Math.min(element.getElementCount() - 1 - n2, (int)Math.signum(n) * n * n));
            int n4 = this.actualPos - element.getElement(n2).getStartOffset();
            Element element2 = element.getElement(n3);
            this.pane.setCaretPosition(Math.min(element2.getStartOffset() + n4, element2.getEndOffset() - 1));
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            this.previousPoint = this.actualPoint;
            this.actualPoint = dropTargetDragEvent.getLocation();
            this.actualPos = this.pane.viewToModel(this.actualPoint);
            this.pane.setCaretPosition(this.actualPos);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        block20: {
            dropTargetDropEvent.acceptDrop(3);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                DataFlavor dataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        for (int i = 0; i < list.size(); ++i) {
                            SciNotes.getEditor().openFile(list.get(i).toString(), 0, null);
                        }
                        dropTargetDropEvent.dropComplete(true);
                        break block20;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    catch (IOException iOException) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                }
                if (transferable.isDataFlavorSupported(dataFlavor)) {
                    String string;
                    try {
                        string = (String)transferable.getTransferData(dataFlavor);
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    catch (IOException iOException) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    List list = DropFilesListener.textURIListToFileList(string);
                    for (int i = 0; i < list.size(); ++i) {
                        SciNotes.getEditor().openFile(list.get(i).toString(), 0, null);
                    }
                    dropTargetDropEvent.dropComplete(true);
                    break block20;
                }
                if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block20;
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    ScilabDocument scilabDocument = (ScilabDocument)this.pane.getDocument();
                    int n = this.pane.viewToModel(dropTargetDropEvent.getLocation());
                    scilabDocument.mergeEditsBegin();
                    if (dropTargetDropEvent.getDropAction() == 2) {
                        scilabDocument.remove(this.p0, this.p1 - this.p0);
                        if (n > this.p1) {
                            n -= this.p1 - this.p0;
                        } else if (n > this.p0) {
                            n = this.p0;
                        }
                    }
                    scilabDocument.insertString(n, string, null);
                    scilabDocument.mergeEditsEnd();
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                catch (IOException iOException) {
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                dropTargetDropEvent.dropComplete(false);
            }
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private static List textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }
}

