/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.scinotes.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.bridge.menubar.SwingScilabMenuBar;
import org.scilab.modules.gui.bridge.toolbar.SwingScilabToolBar;
import org.scilab.modules.gui.checkboxmenuitem.CheckBoxMenuItem;
import org.scilab.modules.scinotes.SciNotes;
import org.scilab.modules.scinotes.ScilabEditorPane;
import org.scilab.modules.scinotes.actions.DefaultCheckAction;
import org.scilab.modules.scinotes.utils.ConfigSciNotesManager;
import org.scilab.modules.scinotes.utils.SciNotesMessages;

public class RestoreOpenedFilesAction
extends DefaultCheckAction {
    private static final int GAP = 10;
    private static final String ESCAPE = "ESCAPE";
    private static final Icon SCILAB_ICON = new ImageIcon(FindIconHelper.findIcon((String)"scilab"));
    private static List<File> selectedFiles;
    private static Map<SciNotes, List<Component>> listOfComponents;

    public RestoreOpenedFilesAction(String string, SciNotes sciNotes) {
        super(string, sciNotes);
    }

    @Override
    public void doAction() {
        ConfigSciNotesManager.saveRestoreOpenedFiles(this.getState());
    }

    public static CheckBoxMenuItem createMenu(String string, SciNotes sciNotes, KeyStroke keyStroke) {
        CheckBoxMenuItem checkBoxMenuItem = RestoreOpenedFilesAction.createCheckBoxMenu(string, null, new RestoreOpenedFilesAction(string, sciNotes), keyStroke);
        boolean bl = ConfigSciNotesManager.getRestoreOpenedFiles();
        checkBoxMenuItem.setChecked(bl);
        return checkBoxMenuItem;
    }

    public static List<File> getSelectedFiles() {
        return selectedFiles;
    }

    private static void saveEnabledComponents(SciNotes sciNotes) {
        int n;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        SwingScilabMenuBar swingScilabMenuBar = (SwingScilabMenuBar)sciNotes.getMenuBar().getAsSimpleMenuBar();
        SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)sciNotes.getToolBar().getAsSimpleToolBar();
        for (n = 0; n < swingScilabMenuBar.getMenuCount(); ++n) {
            if (!swingScilabMenuBar.getMenu(n).isEnabled()) continue;
            arrayList.add(swingScilabMenuBar.getMenu(n));
            swingScilabMenuBar.getMenu(n).setEnabled(false);
        }
        for (n = 0; n < swingScilabToolBar.getComponentCount(); ++n) {
            if (!swingScilabToolBar.getComponent(n).isEnabled()) continue;
            arrayList.add(swingScilabToolBar.getComponent(n));
            swingScilabToolBar.getComponent(n).setEnabled(false);
        }
        if (listOfComponents == null) {
            listOfComponents = new HashMap<SciNotes, List<Component>>();
        }
        listOfComponents.put(sciNotes, arrayList);
    }

    public static void restoreEnabledComponents(SciNotes sciNotes) {
        if (listOfComponents != null && listOfComponents.containsKey((Object)sciNotes)) {
            SwingScilabMenuBar swingScilabMenuBar = (SwingScilabMenuBar)sciNotes.getMenuBar().getAsSimpleMenuBar();
            SwingScilabToolBar swingScilabToolBar = (SwingScilabToolBar)sciNotes.getToolBar().getAsSimpleToolBar();
            List<Component> list = listOfComponents.get((Object)sciNotes);
            for (Component component : list) {
                component.setEnabled(true);
            }
            list.clear();
            listOfComponents.remove((Object)sciNotes);
            if (listOfComponents.isEmpty()) {
                listOfComponents = null;
            }
        }
    }

    public static void forceRestore(SciNotes sciNotes, String string) {
        boolean bl;
        List<File> list = RestoreOpenedFilesAction.removeAlreadyOpenFiles(string);
        boolean bl2 = bl = sciNotes.getTabPane().getTabCount() == 1;
        if (list != null && list.size() != 0) {
            for (File file : list) {
                sciNotes.openFile(file.getPath(), 0, null);
            }
            if (bl) {
                sciNotes.getTabPane().setSelectedIndex(0);
            }
        } else if (sciNotes.getTabPane().getTabCount() == 0) {
            sciNotes.addEmptyTab();
        }
        if (sciNotes.getNavigator() != null) {
            sciNotes.getNavigator().updateTree();
        }
        RestoreOpenedFilesAction.restoreEnabledComponents(sciNotes);
    }

    public static JPanel getTab(final SciNotes sciNotes, final String string) {
        final JTree jTree = RestoreOpenedFilesAction.fillTree(string);
        if (jTree == null) {
            return null;
        }
        JButton jButton = new JButton(SciNotesMessages.OK);
        JButton jButton2 = new JButton(SciNotesMessages.CANCEL);
        jButton.setPreferredSize(jButton2.getPreferredSize());
        Object[] objectArray = new Object[2];
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                List<File> list = RestoreOpenedFilesAction.getOpenedFiles(jTree, string);
                sciNotes.getTabPane().remove(0);
                boolean bl2 = bl = sciNotes.getTabPane().getTabCount() == 1;
                if (list != null && list.size() != 0) {
                    for (File file : list) {
                        sciNotes.openFile(file.getPath(), 0, null);
                    }
                    if (bl) {
                        sciNotes.getTabPane().setSelectedIndex(0);
                    }
                } else if (sciNotes.getTabPane().getTabCount() == 0) {
                    sciNotes.addEmptyTab();
                }
                if (sciNotes.getNavigator() != null) {
                    sciNotes.getNavigator().updateTree();
                }
                RestoreOpenedFilesAction.restoreEnabledComponents(sciNotes);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<UUID> list = ConfigSciNotesManager.getOpenFilesEditorList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!list.get(i).toString().equals(string)) continue;
                    ConfigSciNotesManager.removeFromOpenFiles(list.get(i));
                    break;
                }
                sciNotes.getTabPane().remove(0);
                if (sciNotes.getTabPane().getTabCount() == 0) {
                    sciNotes.addEmptyTab();
                }
                RestoreOpenedFilesAction.restoreEnabledComponents(sciNotes);
            }
        });
        if (RestoreOpenedFilesAction.isWindows()) {
            objectArray[0] = jButton;
            objectArray[1] = jButton2;
        } else {
            objectArray[0] = jButton2;
            objectArray[1] = jButton;
        }
        JOptionPane jOptionPane = new JOptionPane(SciNotesMessages.RESTORE_FILES_QUERY, 3, 2, null, objectArray);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jOptionPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 0.9;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jButton.requestFocusInWindow();
        RestoreOpenedFilesAction.saveEnabledComponents(sciNotes);
        return jPanel;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    private static List<File> getOpenedFiles(JTree jTree, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TreeModel treeModel = jTree.getModel();
        TreeNode treeNode = (TreeNode)treeModel.getChild(treeModel.getRoot(), 0);
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            CheckBoxNode checkBoxNode = (CheckBoxNode)defaultMutableTreeNode.getUserObject();
            if (checkBoxNode.isSelected()) {
                arrayList.add(checkBoxNode.getFile());
                continue;
            }
            arrayList2.add(checkBoxNode.getFile().getAbsolutePath());
        }
        ConfigSciNotesManager.removeFromOpenFiles(UUID.fromString(string), arrayList2);
        return arrayList;
    }

    private static JTree fillTree(String string) {
        List<UUID> list = ConfigSciNotesManager.getOpenFilesEditorList();
        Vector<FilesVector> vector = new Vector<FilesVector>(1);
        List<File> list2 = RestoreOpenedFilesAction.removeAlreadyOpenFiles(string);
        if (list2.size() <= 0) {
            return null;
        }
        vector.add(new FilesVector("SciNotes", list2));
        JTree jTree = new JTree(vector);
        CheckBoxNodeRenderer checkBoxNodeRenderer = new CheckBoxNodeRenderer();
        jTree.setCellRenderer(checkBoxNodeRenderer);
        jTree.setCellEditor(new CheckBoxNodeEditor(jTree));
        jTree.setEditable(true);
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
        return jTree;
    }

    private static List<File> removeAlreadyOpenFiles(String string) {
        List<File> list = ConfigSciNotesManager.getOpenFilesByEditor(UUID.fromString(string));
        SciNotes sciNotes = SciNotes.getEditorFromUUID(string);
        ArrayList<File> arrayList = new ArrayList<File>();
        if (sciNotes != null) {
            int n = sciNotes.getTabPane().getTabCount();
            block0: for (int i = 0; i < n; ++i) {
                ScilabEditorPane scilabEditorPane = sciNotes.getTextPane(i);
                String string2 = scilabEditorPane.getName();
                if (string2 == null) continue;
                for (File file : list) {
                    if (!file.equals(new File(string2))) continue;
                    arrayList.add(file);
                    continue block0;
                }
            }
        }
        list.removeAll(arrayList);
        return list;
    }

    static class CheckBoxNode {
        private String text;
        private boolean selected;
        private File file;

        public CheckBoxNode(File file, String string, boolean bl) {
            this.file = file;
            this.text = string;
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public File getFile() {
            return this.file;
        }
    }

    static class FilesVector
    extends Vector {
        private final String name;

        public FilesVector(String string, List<File> list) {
            this.name = string;
            for (int i = 0; i < list.size(); ++i) {
                this.add(new CheckBoxNode(list.get(i), list.get(i).getName() + " (in " + list.get(i).getParent() + ")", true));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    static class CheckBoxNodeRenderer
    implements TreeCellRenderer {
        private final JCheckBox leafRenderer = new JCheckBox();
        private final DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
        private final Color selectionBorderColor;
        private final Color selectionForeground;
        private final Color selectionBackground;
        private final Color textForeground;
        private final Color textBackground;
        private File file;

        public CheckBoxNodeRenderer() {
            Boolean bl;
            Font font = UIManager.getFont("Tree.font");
            if (font != null) {
                this.leafRenderer.setFont(font);
            }
            this.leafRenderer.setFocusPainted((bl = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && bl != false);
            this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (bl3) {
                Object object2;
                String string = jTree.convertValueToText(object, bl, bl2, bl3, n, false);
                this.leafRenderer.setText(string);
                this.leafRenderer.setSelected(false);
                this.leafRenderer.setEnabled(jTree.isEnabled());
                if (bl) {
                    this.leafRenderer.setForeground(this.selectionForeground);
                    this.leafRenderer.setBackground(this.selectionBackground);
                } else {
                    this.leafRenderer.setForeground(this.textForeground);
                    this.leafRenderer.setBackground(this.textBackground);
                }
                if (object != null && object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof CheckBoxNode) {
                    CheckBoxNode checkBoxNode = (CheckBoxNode)object2;
                    this.leafRenderer.setText(checkBoxNode.getText());
                    this.leafRenderer.setSelected(checkBoxNode.isSelected());
                    this.file = checkBoxNode.getFile();
                }
                return this.leafRenderer;
            }
            return this.nonLeafRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        protected JCheckBox getLeafRenderer() {
            return this.leafRenderer;
        }

        protected File getFile() {
            return this.file;
        }
    }

    static class CheckBoxNodeEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
        private ChangeEvent changeEvent;
        private final JTree tree;

        public CheckBoxNodeEditor(JTree jTree) {
            this.tree = jTree;
        }

        @Override
        public Object getCellEditorValue() {
            JCheckBox jCheckBox = this.renderer.getLeafRenderer();
            CheckBoxNode checkBoxNode = new CheckBoxNode(this.renderer.getFile(), jCheckBox.getText(), jCheckBox.isSelected());
            return checkBoxNode;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            MouseEvent mouseEvent;
            TreePath treePath;
            boolean bl = false;
            if (eventObject instanceof MouseEvent && (treePath = this.tree.getPathForLocation((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null && (object = treePath.getLastPathComponent()) != null && object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                bl = defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode.getUserObject() instanceof CheckBoxNode;
            }
            return bl;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (this.stopCellEditing()) {
                        this.fireEditingStopped();
                    }
                }
            };
            if (component instanceof JCheckBox) {
                ((JCheckBox)component).addItemListener(itemListener);
            }
            return component;
        }
    }
}

