/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools.XML;

import java.io.IOException;
import org.scilab.modules.helptools.XML.AbstractXMLCodeHandler;

public class HTMLXMLCodeHandler
extends AbstractXMLCodeHandler {
    private static final int BUFCAPACITY = 8192;
    private static HTMLXMLCodeHandler handler = new HTMLXMLCodeHandler();
    protected Appendable buffer = new StringBuilder(8192);

    protected HTMLXMLCodeHandler() {
    }

    public static AbstractXMLCodeHandler getInstance() {
        ((StringBuilder)HTMLXMLCodeHandler.handler.buffer).setLength(0);
        return handler;
    }

    public static String replaceEntity(String string) {
        return string.replaceAll("&", "&amp;").replaceAll("<", "&#0060;").replaceAll(">", "&#0062;").replaceAll("\"", "&#0034;").replaceAll("'", "&#0039;");
    }

    @Override
    public void handleDefault(String string) throws IOException {
        this.buffer.append("<span class=\"xmldefault\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleEntity(String string) throws IOException {
        this.buffer.append("<span class=\"xmlentity\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleNothing(String string) throws IOException {
        this.buffer.append(string);
    }

    @Override
    public void handleOpenInstr(String string) throws IOException {
        this.buffer.append("<span class=\"xmlopeninstr\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleCloseInstr(String string) throws IOException {
        this.buffer.append("<span class=\"xmlcloseinstr\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleInstrName(String string) throws IOException {
        this.buffer.append("<span class=\"xmlinstrname\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleLow(String string) throws IOException {
        this.buffer.append("<span class=\"xmllowtag\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOpenTagName(String string) throws IOException {
        this.buffer.append("<span class=\"xmltagname\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleLowClose(String string) throws IOException {
        this.buffer.append("<span class=\"xmllowclose\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleGreat(String string) throws IOException {
        this.buffer.append("<span class=\"xmlgreattag\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOpenComment(String string) throws IOException {
        this.buffer.append("<span class=\"xmlopencomment\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleOpenCdata(String string) throws IOException {
        this.buffer.append("<span class=\"xmlopencdata\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleAttributeName(String string) throws IOException {
        this.buffer.append("<span class=\"xmlattributename\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleEqual(String string) throws IOException {
        this.buffer.append("<span class=\"xmlequal\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleAttributeValue(String string) throws IOException {
        this.buffer.append("<span class=\"xmlattributevalue\">");
        this.buffer.append(HTMLXMLCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    @Override
    public void handleAutoClose(String string) throws IOException {
        this.buffer.append("<span class=\"xmlautoclose\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleCommentEnd(String string) throws IOException {
        this.buffer.append("<span class=\"xmlcommentend\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleComment(String string) throws IOException {
        this.buffer.append("<span class=\"xmlcomment\">");
        this.buffer.append(HTMLXMLCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    @Override
    public void handleCdataEnd(String string) throws IOException {
        this.buffer.append("<span class=\"xmlcdataend\">");
        this.buffer.append(string);
        this.buffer.append("</span>");
    }

    @Override
    public void handleCdata(String string) throws IOException {
        this.buffer.append("<span class=\"xmlcdata\">");
        this.buffer.append(HTMLXMLCodeHandler.replaceEntity(string));
        this.buffer.append("</span>");
    }

    public String toString() {
        return this.buffer.toString();
    }
}

