/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.helptools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.scilab.modules.commons.ScilabCommonsUtils;
import org.scilab.modules.commons.ScilabConstants;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.helptools.HTMLDocbookLinkResolver;
import org.scilab.modules.helptools.HTMLDocbookTagConverter;
import org.scilab.modules.helptools.SciDocMain;
import org.scilab.modules.helptools.image.ImageConverter;
import org.xml.sax.SAXException;

public class JavaHelpDocbookTagConverter
extends HTMLDocbookTagConverter {
    private static final String XMLSTRING = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n";
    private StringBuilder buffer = new StringBuilder(8192);

    public JavaHelpDocbookTagConverter(String string, SciDocMain sciDocMain, ImageConverter imageConverter) throws IOException, SAXException {
        super(string, sciDocMain, imageConverter);
        this.urlBase = "scilab://";
        this.linkToTheWeb = false;
        if (!this.isToolbox) {
            this.outImages = ScilabConstants.SCI.getPath() + "/modules/helptools/images";
            File file = new File(this.outImages);
            if (!file.exists()) {
                file.mkdir();
            }
        }
        this.prependToProgramListing = "<table border=\"0\" width=\"100%\"><tr><td width=\"98%\">";
        this.appendToProgramListing = "</td><td valign=\"top\"><a href=\"scilab://scilab.execexample/\"><img src=\"" + this.getBaseImagePath() + "ScilabExecute.png\" border=\"0\"/></a></td><td valign=\"top\"><a href=\"scilab://scilab.editexample/\"><img src=\"" + this.getBaseImagePath() + "ScilabEdit.png\" border=\"0\"/></a></td><td></td></tr></table>";
        this.appendForExecToProgramListing = "</td><td valign=\"top\"><a href=\"scilab://scilab.execexample/\"><img src=\"" + this.getBaseImagePath() + "ScilabExecute.png\" border=\"0\"/></a></td><td></td></tr></table>";
    }

    @Override
    public void install() {
        super.install();
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"media-playback-start")), (File)new File(this.outImages + "/ScilabExecute.png"));
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"accessories-text-editor")), (File)new File(this.outImages + "/ScilabEdit.png"));
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"dialog-information")), (File)new File(this.outImages + "/ScilabNote.png"));
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"dialog-warning")), (File)new File(this.outImages + "/ScilabWarning.png"));
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"dialog-warning")), (File)new File(this.outImages + "/ScilabCaution.png"));
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"dialog-information")), (File)new File(this.outImages + "/ScilabTip.png"));
        ScilabCommonsUtils.copyFile((File)new File(FindIconHelper.findIcon((String)"emblem-important")), (File)new File(this.outImages + "/ScilabImportant.png"));
        if (!this.isToolbox) {
            File file;
            ScilabCommonsUtils.copyFile((File)new File(SCI + "/modules/helptools/data/pages/error.html"), (File)new File(this.outName + "/ScilabErrorPage.html"));
            File file2 = new File(SCI + "/modules/helptools/data/pages/homepage-" + this.language + ".html");
            if (!file2.isFile()) {
                file2 = new File(SCI + "/modules/helptools/data/pages/homepage-en_US.html");
            }
            ScilabCommonsUtils.copyFile((File)file2, (File)new File(this.outName + "/ScilabHomePage.html"));
            File file3 = new File(SCI + "/modules/helptools/data/pages/CHANGES.html");
            if (file3.isFile()) {
                ScilabCommonsUtils.copyFile((File)file3, (File)new File(this.outName + "/CHANGES.html"));
            }
            if (!(file = new File(SCI + "/modules/helptools/data/pages/ban-" + this.language + ".png")).isFile()) {
                file = new File(SCI + "/modules/helptools/data/pages/ban-en_US.png");
            }
            ScilabCommonsUtils.copyFile((File)file, (File)new File(this.outImages + "/ban_en_US.png"));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try (FileOutputStream fileOutputStream = new FileOutputStream("jhelptoc.xml");
             FileOutputStream fileOutputStream2 = new FileOutputStream("jhelpmap.jhm");
             FileOutputStream fileOutputStream3 = new FileOutputStream("jhelpset.hs");
             FileOutputStream fileOutputStream4 = new FileOutputStream("jhelpidx.xml");
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream4, Charset.forName("UTF-8"));
             OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter((OutputStream)fileOutputStream3, Charset.forName("UTF-8"));
             OutputStreamWriter outputStreamWriter3 = new OutputStreamWriter((OutputStream)fileOutputStream2, Charset.forName("UTF-8"));
             OutputStreamWriter outputStreamWriter4 = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));){
            outputStreamWriter3.append(XMLSTRING);
            outputStreamWriter3.append("<!DOCTYPE map PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\" \"http://java.sun.com/products/javahelp/map_1_0.dtd\">\n");
            outputStreamWriter3.append(this.convertMapId());
            outputStreamWriter3.flush();
            fileOutputStream2.flush();
            outputStreamWriter4.append(XMLSTRING);
            outputStreamWriter4.append("<!DOCTYPE toc PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp TOC Version 1.0//EN\" \"http://java.sun.com/products/javahelp/toc_1_0.dtd\">\n");
            outputStreamWriter4.append(this.convertTocItem());
            outputStreamWriter4.flush();
            fileOutputStream.flush();
            outputStreamWriter2.append(XMLSTRING);
            String string = "<!DOCTYPE helpset\n  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN\" \"http://java.sun.com/products/javahelp/helpset_1_0.dtd\">\n<helpset version=\"1.0\">\n<title>TITLE</title>\n<maps>\n<homeID>top</homeID>\n<mapref location=\"jhelpmap.jhm\"/>\n</maps>\n<view>\n<name>TOC</name>\n<label>Table Of Contents</label>\n<type>javax.help.TOCView</type>\n<data>jhelptoc.xml</data>\n</view>\n<view>\n<name>Index</name>\n<label>Index</label>\n<type>javax.help.IndexView</type>\n<data>jhelpidx.xml</data>\n</view>\n<view>\n<name>Search</name>\n<label>Search</label>\n<type>javax.help.SearchView</type>\n<data engine=\"com.sun.java.help.search.DefaultSearchEngine\">JavaHelpSearch</data>\n</view>\n</helpset>".replaceFirst("TITLE", this.bookTitle);
            outputStreamWriter2.append(string);
            outputStreamWriter2.flush();
            fileOutputStream3.flush();
            outputStreamWriter.append(XMLSTRING);
            outputStreamWriter.append("<!DOCTYPE index PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Index Version 1.0//EN\" \"http://java.sun.com/products/javahelp/index_1_0.dtd\">\n<index version=\"1.0\"/>");
            outputStreamWriter.flush();
            fileOutputStream4.flush();
            if (!this.isToolbox) {
                this.getImageConverter().saveMD5s(ScilabConstants.SCI.getPath() + "/modules/helptools/etc");
            }
        }
        catch (IOException iOException) {
            this.fatalExceptionOccurred(iOException);
        }
    }

    @Override
    protected String makeRemoteLink(String string) {
        return "file://SCI/modules/" + string;
    }

    @Override
    public String getBaseImagePath() {
        if (this.isToolbox) {
            return super.getBaseImagePath();
        }
        return "jarsci:";
    }

    private String convertMapId() {
        this.buffer.setLength(0);
        this.buffer.append("<map version=\"1.0\">\n<mapID target=\"index\" url=\"index.html\"/>\n");
        if (!this.isToolbox) {
            this.buffer.append("<mapID target=\"whatsnew\" url=\"ScilabHomePage.html\"/>\n");
        }
        for (String string : this.mapId.keySet()) {
            this.buffer.append("<mapID target=\"");
            this.buffer.append(string);
            this.buffer.append("\" url=\"");
            this.buffer.append((String)this.mapId.get(string));
            this.buffer.append("\"/>\n");
        }
        this.buffer.append("</map>");
        return this.buffer.toString();
    }

    private void convertTreeId(HTMLDocbookLinkResolver.TreeId treeId) {
        if (treeId.children != null) {
            for (HTMLDocbookLinkResolver.TreeId treeId2 : treeId.children) {
                this.buffer.append("<tocitem target=\"");
                this.buffer.append(treeId2.id);
                this.buffer.append("\" text=\"");
                this.buffer.append((String)this.tocitem.get(treeId2.id));
                if (treeId2.children == null) {
                    this.buffer.append("\"/>\n");
                    continue;
                }
                this.buffer.append("\">\n");
                this.convertTreeId(treeId2);
                this.buffer.append("</tocitem>\n");
            }
        }
    }

    private String convertTocItem() {
        this.buffer.setLength(0);
        this.buffer.append("<toc version=\"1.0\">\n<tocitem target=\"index\" text=\"" + this.bookTitle + "\">\n");
        if (!this.isToolbox) {
            this.buffer.append("<tocitem target=\"whatsnew\" text=\"Scilab Home\"/>\n");
        }
        this.convertTreeId(this.tree);
        this.buffer.append("</tocitem>\n</toc>");
        return this.buffer.toString();
    }
}

