/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.external_objects_java;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.scilab.modules.external_objects_java.ScilabJavaException;

public class ScilabJarCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int createJarArchive(String string, String[] stringArray, String string2, String object, boolean bl) throws ScilabJavaException {
        JarOutputStream jarOutputStream = null;
        try {
            Manifest manifest;
            List<String> list;
            Object object3;
            block18: {
                block19: {
                    FileInputStream fileInputStream;
                    String[] stringArray2 = new String[stringArray.length];
                    int n = 0;
                    for (String object22 : stringArray) {
                        stringArray2[n++] = new File(object22).getCanonicalPath();
                    }
                    object3 = null;
                    if (string2 == null || string2.isEmpty()) {
                        if (!bl) {
                            object3 = ScilabJarCreator.getCommonPath(stringArray2);
                        }
                    } else {
                        object3 = new File(string2).getCanonicalPath();
                    }
                    list = ScilabJarCreator.expandPaths(stringArray2);
                    manifest = null;
                    if (object == null || ((String)object).isEmpty()) {
                        object = (String)object3 + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
                    }
                    if (!new File((String)object).exists()) break block19;
                    FileInputStream fileInputStream2 = null;
                    try {
                        fileInputStream = new FileInputStream((String)object);
                        manifest = new Manifest(fileInputStream);
                        if (fileInputStream != null) {
                        }
                        break block18;
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                        break block18;
                    }
                    fileInputStream.close();
                    break block18;
                    finally {
                        if (fileInputStream2 != null) {
                            fileInputStream2.close();
                        }
                    }
                }
                manifest = new Manifest();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
            Iterator<String> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    ScilabJarCreator.closeJarArchive(jarOutputStream);
                    return 0;
                }
                String string3 = iterator.next();
                File file = new File(string3);
                String string4 = object3 != null && !((String)object3).isEmpty() ? ScilabJarCreator.getRelativePath((String)object3, string3) : (bl ? file.getPath() : file.getName());
                if (string4.equals("META-INF/MANIFEST.MF")) continue;
                ScilabJarCreator.addFileToJarArchive(file, string4, jarOutputStream);
            }
        }
        catch (IOException iOException) {
            try {
                ScilabJarCreator.closeJarArchive(jarOutputStream);
                ScilabJarCreator.deleteJarArchive(string);
                throw new ScilabJavaException(String.format("Cannot create jar archive %s: %s", string, iOException.getMessage()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ScilabJavaException(String.format("Cannot create jar archive %s: %s", string, iOException.getMessage()));
        }
    }

    private static List<String> expandPaths(String ... stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            File file = new File(string);
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    arrayList.addAll(ScilabJarCreator.expandPaths(file2.getPath()));
                }
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToJarArchive(File file, String string, JarOutputStream jarOutputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = null;){
            int n;
            string.replace("\\", "/");
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setTime(file.lastModified());
            jarOutputStream.putNextEntry(jarEntry);
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                jarOutputStream.write(byArray, 0, n);
            }
            jarOutputStream.closeEntry();
        }
    }

    private static String getCommonPath(String[] stringArray) throws IOException {
        int n = stringArray.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            File file = new File(stringArray[0]);
            if (file.isDirectory()) {
                return file.getAbsolutePath();
            }
            return file.getParentFile().getAbsolutePath();
        }
        String string = Pattern.quote(System.getProperty("file.separator"));
        Object object = "";
        String[][] stringArrayArray = new String[n][];
        int n2 = 0;
        for (String string2 : stringArray) {
            stringArrayArray[n2++] = string2.split(string);
        }
        for (int i = 0; i < stringArrayArray[0].length; ++i) {
            String string3 = stringArrayArray[0][i];
            int n3 = 1;
            for (int j = 1; j < stringArrayArray.length && n3 != 0; n3 &= new File(stringArrayArray[j][i]).compareTo(new File(string3)) == 0 ? 1 : 0, ++j) {
                if (i < stringArrayArray[j].length) continue;
                return object;
            }
            if (n3 == 0) {
                return object;
            }
            object = (String)object + string3 + File.separator;
        }
        return object;
    }

    private static String getRelativePath(String string, String string2) {
        return new File(string).toURI().relativize(new File(string2).toURI()).getPath();
    }

    private static void closeJarArchive(JarOutputStream jarOutputStream) throws ScilabJavaException {
        try {
            if (jarOutputStream != null) {
                jarOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ScilabJavaException(String.format("Cannot close jar stream: %s%n", iOException.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void deleteJarArchive(String string) throws ScilabJavaException {
        File file = new File(string);
        if (!file.exists()) throw new ScilabJavaException(String.format("Cannot delete jar archive %s: No such file.%n", string));
        if (!file.canWrite()) throw new ScilabJavaException(String.format("Cannot delete jar archive %s: File is write protected.%n", string));
        if (file.delete()) return;
        throw new ScilabJavaException(String.format("Cannot delete jar archive %s.%n", string));
    }
}

