/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.history_manager;

import org.scilab.modules.commons.xml.XConfiguration;
import org.scilab.modules.commons.xml.XConfigurationEvent;
import org.scilab.modules.commons.xml.XConfigurationListener;
import org.scilab.modules.history_manager.HistoryManagement;
import org.w3c.dom.Document;

public class HistoryPrefs
implements XConfigurationListener {
    private static final String HISTORY_PATH = "//command-history/body/history-settings";
    private static final HistoryPrefs instance = new HistoryPrefs();

    private HistoryPrefs() {
    }

    public static HistoryPrefs getInstance() {
        return instance;
    }

    public void configurationChanged(XConfigurationEvent xConfigurationEvent) {
        if (xConfigurationEvent.getModifiedPaths().contains(HISTORY_PATH) || xConfigurationEvent.getModifiedPaths().contains("ALL")) {
            Document document = XConfiguration.getXConfigurationDocument();
            HistoryOption historyOption = ((HistoryOption[])XConfiguration.get(HistoryOption.class, (Document)document, (String)HISTORY_PATH))[0];
            if (historyOption.enable) {
                HistoryManagement.InitializeHistoryManager();
                HistoryManagement.setFilenameScilabHistory(historyOption.historyFile);
                HistoryManagement.setSizeMaxScilabHistory(historyOption.historyLines);
            } else {
                HistoryManagement.TerminateHistoryManager();
            }
        }
    }

    @XConfiguration.XConfAttribute
    private static class HistoryOption {
        public String historyFile;
        public int historyLines;
        public boolean enable;

        private HistoryOption() {
        }

        @XConfiguration.XConfAttribute(attributes={"history-file", "history-lines", "enable"})
        private void set(String string, int n, boolean bl) {
            this.historyFile = string;
            this.historyLines = n;
            this.enable = bl;
        }
    }
}

