/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.types;

import java.io.ObjectStreamException;
import java.nio.IntBuffer;
import org.scilab.modules.types.ScilabBoolean;
import org.scilab.modules.types.ScilabTypeUtils;

public class ScilabBooleanReference
extends ScilabBoolean {
    private final IntBuffer intBuffer;
    private final int nbRows;
    private final int nbCols;

    public ScilabBooleanReference(String string, IntBuffer intBuffer, int n, int n2) {
        this.varName = string;
        this.intBuffer = intBuffer;
        this.swaped = false;
        this.nbRows = n;
        this.nbCols = n2;
        this.byref = true;
    }

    @Override
    public boolean isEmpty() {
        return this.nbRows == 0 || this.nbCols == 0;
    }

    @Override
    public boolean getElement(int n, int n2) {
        return this.intBuffer.get(n + this.nbRows * n2) != 0;
    }

    @Override
    public void setElement(int n, int n2, boolean bl) {
        this.intBuffer.put(n + this.nbRows * n2, bl ? 1 : 0);
    }

    @Override
    public void setData(boolean[][] blArray) {
        ScilabTypeUtils.setPart(this.intBuffer, blArray);
    }

    @Override
    public boolean[][] getData() {
        boolean[][] blArray = new boolean[this.nbRows][this.nbCols];
        ScilabTypeUtils.setBuffer(blArray, this.intBuffer);
        return blArray;
    }

    @Override
    public Object getRawData() {
        return this.intBuffer;
    }

    private Object readResolve() throws ObjectStreamException {
        return new ScilabBoolean(this.varName, this.data, this.swaped);
    }

    @Override
    public int getHeight() {
        return this.nbRows;
    }

    @Override
    public int getWidth() {
        return this.nbCols;
    }
}

