/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scilab.forge.scirenderer.implementation.g2d.motor.ConvexObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.G2DStroke;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.implementation.g2d.motor.SpritedRectangle;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Triangle;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public class Segment
extends ConvexObject
implements Comparable<Segment> {
    private int hash = -1;
    protected G2DStroke stroke;
    protected List<ConvexObject> segmentOn;
    protected boolean is2D;
    protected double[] clip = new double[]{Double.NaN, Double.NaN, Double.NaN, Double.NaN};

    public Segment(Vector3d[] vector3dArray, Color[] colorArray, G2DStroke g2DStroke, boolean bl) throws InvalidPolygonException {
        super(vector3dArray, colorArray);
        if (vector3dArray.length != 2) {
            throw new InvalidPolygonException("Invalid segment: must have 2 vertices.");
        }
        this.stroke = g2DStroke;
        this.is2D = bl;
    }

    public Segment(Vector3d[] vector3dArray, Color[] colorArray) throws InvalidPolygonException {
        this(vector3dArray, colorArray, null, false);
    }

    public void setStroke(G2DStroke g2DStroke) {
        this.stroke = g2DStroke;
    }

    public double getLength() {
        return this.vertices[0].minus(this.vertices[1]).getNorm();
    }

    public static double getLength(Vector3d[] vector3dArray) {
        return vector3dArray[0].minus(vector3dArray[1]).getNorm();
    }

    public void addConvexObject(ConvexObject convexObject) {
        if (this.segmentOn == null) {
            this.segmentOn = new ArrayList<ConvexObject>(2);
        }
        this.segmentOn.add(convexObject);
    }

    public void removeConvexObject(ConvexObject convexObject) {
        if (this.segmentOn != null) {
            this.segmentOn.remove(convexObject);
        }
    }

    public void replaceSegment(List<Segment> list) {
        if (this.segmentOn != null) {
            for (ConvexObject convexObject : this.segmentOn) {
                Triangle triangle = (Triangle)convexObject;
                triangle.replaceSegment(this, list);
            }
        }
    }

    public boolean isIn2D() {
        return Segment.isNull(this.vertices[0].getZ()) && Segment.isNull(this.vertices[1].getZ());
    }

    public boolean isInFront() {
        return Segment.isEqual(this.vertices[0].getZ(), -0.5) && Segment.isEqual(this.vertices[1].getZ(), -0.5);
    }

    @Override
    public int compareTo(Segment segment) {
        if (this.equals(segment)) {
            return 0;
        }
        return this.getPrecedence() - segment.getPrecedence();
    }

    public boolean equals(Object object) {
        if (object instanceof Segment) {
            Segment segment = (Segment)object;
            return segment.vertices[0].equals(this.vertices[0]) && segment.vertices[1].equals(this.vertices[1]) && segment.getColor(0).equals(this.getColor(0)) && segment.getColor(1).equals(this.getColor(1)) || segment.vertices[1].equals(this.vertices[0]) && segment.vertices[0].equals(this.vertices[1]) && segment.getColor(1).equals(this.getColor(0)) && segment.getColor(0).equals(this.getColor(1));
        }
        return false;
    }

    @Override
    public int isBehind(ConvexObject convexObject) {
        if (convexObject instanceof Triangle && ((Triangle)convexObject).isSegmentAcross(this)) {
            return 1;
        }
        return super.isBehind(convexObject);
    }

    @Override
    public List<ConvexObject> breakObject(ConvexObject convexObject) {
        if (convexObject instanceof Triangle) {
            return ((Triangle)convexObject).breakObject(this);
        }
        if (convexObject instanceof SpritedRectangle) {
            return ((SpritedRectangle)convexObject).breakObject(this);
        }
        return null;
    }

    @Override
    public List<ConvexObject> breakObject(Vector4d vector4d) {
        double[] dArray = vector4d.getData();
        if (this.is2D && dArray[2] == 0.0) {
            ConvexObject.makeClip(this.clip, dArray);
        }
        this.getNormal();
        Vector3d vector3d = new Vector3d(dArray);
        boolean bl = Segment.isBehind(this.vertices[0], vector3d, dArray[3]);
        boolean bl2 = Segment.isBehind(this.vertices[1], vector3d, dArray[3]);
        if (bl && bl2) {
            ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(1);
            arrayList.add(this);
            return arrayList;
        }
        if (!bl && !bl2) {
            return null;
        }
        double d = (dArray[3] + this.vertices[1].scalar(vector3d)) / this.v0.scalar(vector3d);
        Vector3d vector3d2 = Vector3d.getBarycenter(this.vertices[0], this.vertices[1], d, 1.0 - d);
        Color color = Segment.getColorsBarycenter(this.getColor(0), this.getColor(1), d, 1.0 - d);
        try {
            Segment segment = bl ? new Segment(new Vector3d[]{this.vertices[0], vector3d2}, new Color[]{this.getColor(0), color}, this.stroke, this.is2D) : new Segment(new Vector3d[]{vector3d2, this.vertices[1]}, new Color[]{color, this.getColor(1)}, this.stroke, this.is2D);
            ArrayList<ConvexObject> arrayList = new ArrayList<ConvexObject>(1);
            arrayList.add(segment);
            return arrayList;
        }
        catch (InvalidPolygonException invalidPolygonException) {
            return null;
        }
    }

    public List<Segment> breakObject(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.getNormal();
        double d = this.vertices[1].minus(vector3d).scalar(vector3d3) / this.v0.scalar(vector3d3);
        if (d > 0.0 && !Segment.isNull(d) && d < 1.0 && !Segment.isEqual(d, 1.0)) {
            ArrayList<Segment> arrayList = new ArrayList<Segment>(2);
            Vector3d vector3d4 = Vector3d.getBarycenter(this.vertices[0], this.vertices[1], d, 1.0 - d);
            Color color = Segment.getColorsBarycenter(this.getColor(0), this.getColor(1), d, 1.0 - d);
            try {
                arrayList.add(new Segment(new Vector3d[]{this.vertices[0], vector3d4}, new Color[]{this.getColor(0), color}, this.stroke, this.is2D));
                arrayList.add(new Segment(new Vector3d[]{vector3d4, this.vertices[1]}, new Color[]{color, this.getColor(1)}, this.stroke, this.is2D));
                return arrayList;
            }
            catch (InvalidPolygonException invalidPolygonException) {}
        } else {
            ArrayList<Segment> arrayList = new ArrayList<Segment>(1);
            try {
                arrayList.add(new Segment(new Vector3d[]{this.vertices[0], this.vertices[1]}, new Color[]{this.getColor(0), this.getColor(1)}, this.stroke, this.is2D));
                return arrayList;
            }
            catch (InvalidPolygonException invalidPolygonException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.segmentOn == null || this.segmentOn.isEmpty()) {
            Path2D path2D = this.getProjectedPolyLine();
            graphics2D.setColor(this.getColor(0));
            Stroke stroke = graphics2D.getStroke();
            if (stroke != this.stroke) {
                graphics2D.setStroke(this.stroke);
            }
            Shape shape = graphics2D.getClip();
            Shape shape2 = ConvexObject.getClip(this.clip);
            if (shape2 != null) {
                graphics2D.clip(shape2);
            }
            graphics2D.draw(path2D);
            if (stroke != this.stroke) {
                graphics2D.setStroke(stroke);
            }
            if (shape2 != null) {
                graphics2D.setClip(shape);
            }
            this.drawAreas(graphics2D);
        }
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.colors != null ? Arrays.hashCode(this.vertices) + 19 * Arrays.hashCode(this.colors) : Arrays.hashCode(this.vertices) + 19 * this.getColor(0).hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return "Segment " + this.vertices[0].toString() + " " + this.vertices[1].toString() + " Precedence: " + this.getPrecedence();
    }
}

