/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.scilab.forge.scirenderer.implementation.g2d.lighting.G2DLight;
import org.scilab.forge.scirenderer.shapes.appearance.Material;
import org.scilab.forge.scirenderer.tranformations.Vector3f;

public class LightHelper {
    public static Vector3f[] getVector3f(FloatBuffer floatBuffer, int n) {
        float[] fArray;
        if (floatBuffer == null) {
            return null;
        }
        if (n < 3) {
            return null;
        }
        floatBuffer.rewind();
        if (floatBuffer.hasArray()) {
            fArray = floatBuffer.array();
        } else {
            fArray = new float[floatBuffer.limit()];
            floatBuffer.get(fArray);
        }
        Vector3f[] vector3fArray = new Vector3f[fArray.length / n];
        for (int i = 0; i < fArray.length; i += n) {
            vector3fArray[i] = new Vector3f(fArray[i], fArray[i + 1], fArray[i + 2]);
        }
        return vector3fArray;
    }

    public static Vector3f[] getIndexedVector3f(FloatBuffer floatBuffer, IntBuffer intBuffer, int n, float[] fArray) {
        int[] nArray;
        float[] fArray2;
        if (floatBuffer == null || intBuffer == null) {
            return null;
        }
        if (n < 3) {
            return null;
        }
        floatBuffer.rewind();
        if (floatBuffer.hasArray()) {
            fArray2 = floatBuffer.array();
        } else {
            fArray2 = new float[floatBuffer.limit()];
            floatBuffer.get(fArray2);
        }
        intBuffer.rewind();
        if (intBuffer.hasArray()) {
            nArray = intBuffer.array();
        } else {
            nArray = new int[intBuffer.limit()];
            intBuffer.get(nArray);
        }
        Vector3f[] vector3fArray = new Vector3f[nArray.length];
        if (fArray != null && fArray.length == 16) {
            for (int i = 0; i < nArray.length; ++i) {
                vector3fArray[i] = LightHelper.transform(fArray2[n * nArray[i]], fArray2[n * nArray[i] + 1], fArray2[n * nArray[i] + 2], fArray);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                vector3fArray[i] = new Vector3f(fArray2[n * nArray[i]], fArray2[n * nArray[i] + 1], fArray2[n * nArray[i] + 2]);
            }
        }
        return vector3fArray;
    }

    static Vector3f transform(float f, float f2, float f3, float[] fArray) {
        float f4 = fArray[0] * f + fArray[4] * f2 + fArray[8] * f3 + fArray[12];
        float f5 = fArray[1] * f + fArray[5] * f2 + fArray[9] * f3 + fArray[13];
        float f6 = fArray[2] * f + fArray[6] * f2 + fArray[10] * f3 + fArray[14];
        return new Vector3f(f4, f5, f6);
    }

    static Vector3f transformDirection(float f, float f2, float f3, float[] fArray) {
        float f4 = fArray[0] * f + fArray[4] * f2 + fArray[8] * f3;
        float f5 = fArray[1] * f + fArray[5] * f2 + fArray[9] * f3;
        float f6 = fArray[2] * f + fArray[6] * f2 + fArray[10] * f3;
        return new Vector3f(f4, f5, f6);
    }

    public static Color[] applyAmbient(Color color, Color[] colorArray, boolean bl) {
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = bl ? LightHelper.getColorSum(color, colorArray[i]) : color;
        }
        return colorArray;
    }

    public static Color[] applyAmbient(Color color, Color[] colorArray, Color[] colorArray2, boolean bl) {
        for (int i = 0; i < colorArray2.length; ++i) {
            colorArray2[i] = bl ? LightHelper.getColorSum(LightHelper.getColorProduct(color, colorArray[i]), colorArray2[i]) : LightHelper.getColorProduct(color, colorArray[i]);
        }
        return colorArray2;
    }

    public static Color[] applyDiffuse(Vector3f vector3f, boolean bl, Vector3f[] vector3fArray, Vector3f[] vector3fArray2, Color[] colorArray, Color color, Color[] colorArray2, boolean bl2) {
        for (int i = 0; i < colorArray.length; ++i) {
            Object object;
            float f;
            if (bl) {
                f = vector3fArray2[i].scalar(vector3f);
            } else {
                object = vector3f.minus(vector3fArray[i]).getNormalized();
                f = vector3fArray2[i].scalar((Vector3f)object);
            }
            f = LightHelper.clamp(f);
            object = LightHelper.getColorProduct(colorArray[i], color);
            colorArray2[i] = bl2 ? LightHelper.getColorSum(LightHelper.getColorProduct((Color)object, f), colorArray2[i]) : LightHelper.getColorProduct((Color)object, f);
        }
        return colorArray2;
    }

    public static Color[] applyDiffuse(Vector3f vector3f, boolean bl, Vector3f[] vector3fArray, Vector3f[] vector3fArray2, Color color, Color[] colorArray, boolean bl2) {
        for (int i = 0; i < colorArray.length; ++i) {
            float f;
            if (bl) {
                f = vector3fArray2[i].scalar(vector3f);
            } else {
                Vector3f vector3f2 = vector3f.minus(vector3fArray[i]).getNormalized();
                f = vector3fArray2[i].scalar(vector3f2);
            }
            f = LightHelper.clamp(f);
            colorArray[i] = bl2 ? LightHelper.getColorSum(LightHelper.getColorProduct(color, f), colorArray[i]) : LightHelper.getColorProduct(color, f);
        }
        return colorArray;
    }

    public static Color[] applySpecular(Vector3f vector3f, Vector3f vector3f2, float f, boolean bl, Vector3f[] vector3fArray, Vector3f[] vector3fArray2, Color color, Color[] colorArray, boolean bl2) {
        for (int i = 0; i < colorArray.length; ++i) {
            float f2;
            Vector3f vector3f3;
            Vector3f vector3f4 = vector3f.minus(vector3fArray[i]).getNormalized();
            if (bl) {
                vector3f3 = vector3f4.plus(vector3f2);
                f2 = vector3fArray2[i].scalar(vector3f2);
            } else {
                Vector3f vector3f5 = vector3f2.minus(vector3fArray[i]).getNormalized();
                vector3f3 = vector3f4.plus(vector3f5);
                f2 = vector3fArray2[i].scalar(vector3f5);
            }
            vector3f3 = vector3f3.getNormalized();
            float f3 = 0.0f;
            if (f2 > 0.0f) {
                f3 = vector3fArray2[i].scalar(vector3f3);
                f3 = LightHelper.clamp(f3);
                f3 = (float)Math.pow(f3, f);
            }
            colorArray[i] = bl2 ? LightHelper.getColorSum(LightHelper.getColorProduct(color, f3), colorArray[i]) : LightHelper.getColorProduct(color, f3);
        }
        return colorArray;
    }

    public static Color[] applyLight(G2DLight g2DLight, Material material, Vector3f vector3f, Vector3f[] vector3fArray, Vector3f[] vector3fArray2, Color[] colorArray, Color[] colorArray2, float[] fArray, boolean bl) {
        Color color = LightHelper.getColorProduct((Color)material.getAmbientColor(), g2DLight.getAmbientColor());
        Color color2 = LightHelper.getColorProduct((Color)material.getDiffuseColor(), g2DLight.getDiffuseColor());
        Color color3 = LightHelper.getColorProduct((Color)material.getSpecularColor(), g2DLight.getSpecularColor());
        Color[] colorArray3 = material.isColorMaterialEnable() ? LightHelper.applyAmbient(g2DLight.getAmbientColor(), colorArray, colorArray2, bl) : LightHelper.applyAmbient(color, colorArray2, bl);
        float[] fArray2 = g2DLight.isPoint() ? g2DLight.getPosition().getDataAsFloatArray() : g2DLight.getDirection().getDataAsFloatArray();
        Vector3f vector3f2 = fArray != null && fArray.length == 16 ? (g2DLight.isPoint() ? LightHelper.transform(fArray2[0], fArray2[1], fArray2[2], fArray) : LightHelper.transformDirection(fArray2[0], fArray2[1], fArray2[2], fArray).getNormalized()) : new Vector3f(fArray2[0], fArray2[1], fArray2[2]);
        colorArray3 = material.isColorMaterialEnable() ? LightHelper.applyDiffuse(vector3f2, !g2DLight.isPoint(), vector3fArray, vector3fArray2, colorArray, g2DLight.getDiffuseColor(), colorArray3, true) : LightHelper.applyDiffuse(vector3f2, !g2DLight.isPoint(), vector3fArray, vector3fArray2, color2, colorArray3, true);
        colorArray3 = LightHelper.applySpecular(vector3f, vector3f2, material.getShininess(), !g2DLight.isPoint(), vector3fArray, vector3fArray2, color3, colorArray3, true);
        return colorArray3;
    }

    private static Color getColorProduct(Color color, Color color2) {
        float[] fArray = color.getComponents(null);
        float[] fArray2 = color2.getComponents(null);
        return new Color(fArray[0] * fArray2[0], fArray[1] * fArray2[1], fArray[2] * fArray2[2]);
    }

    private static Color getColorProduct(Color color, float f) {
        float[] fArray = color.getComponents(null);
        return new Color(LightHelper.clamp(fArray[0] * f), LightHelper.clamp(fArray[1] * f), LightHelper.clamp(fArray[2] * f));
    }

    private static Color getColorSum(Color color, Color color2) {
        float[] fArray = color.getComponents(null);
        float[] fArray2 = color2.getComponents(null);
        return new Color(LightHelper.clamp(fArray[0] + fArray2[0]), LightHelper.clamp(fArray[1] + fArray2[1]), LightHelper.clamp(fArray[2] + fArray2[2]));
    }

    private static float clamp(float f) {
        f = f < 0.0f ? 0.0f : f;
        f = f > 1.0f ? 1.0f : f;
        return f;
    }

    static Vector3f reflect(Vector3f vector3f, Vector3f vector3f2) {
        return vector3f.minus(vector3f2.times(2.0f * vector3f.scalar(vector3f2)));
    }
}

