/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.BasicStroke;
import org.scilab.forge.scirenderer.shapes.appearance.Appearance;

public class G2DStroke
extends BasicStroke {
    private static final int[] array = new int[16];
    private static final G2DStroke BASIC = new G2DStroke(1.0f, null, 0.0f);
    private static float[] prevArray;
    private static float prevFactor;
    private static short prevPattern;

    public G2DStroke(float f, float[] fArray, float f2) {
        super(f, 0, 0, 10.0f, fArray, f2);
    }

    public static G2DStroke getStroke(Appearance appearance, double d) {
        Appearance appearance2 = appearance == null ? new Appearance() : appearance;
        float f = appearance2.getLineWidth();
        if (f == 0.0f) {
            return new G2DStroke(0.0f, null, 0.0f);
        }
        short s = appearance2.getLinePattern();
        if (s == -1) {
            if (f == 1.0f) {
                return BASIC;
            }
            return new G2DStroke(f, null, 0.0f);
        }
        if (f != prevFactor || s != prevPattern) {
            prevFactor = f;
            prevPattern = s;
            prevArray = G2DStroke.decodePattern(f, s);
        }
        return new G2DStroke(f, prevArray, (float)d);
    }

    private static final float[] decodePattern(float f, short s) {
        int n;
        int n2 = 0xFFFF & s;
        int n3 = 0;
        int n4 = Integer.numberOfTrailingZeros(n2);
        int n5 = Integer.numberOfLeadingZeros(n2 >>= n4) - 16;
        int n6 = 65535;
        int n7 = 2;
        while (true) {
            if (n2 % (n = n6 / ((1 << n7) - 1)) == 0) {
                n2 /= n;
                break;
            }
            ++n7;
        }
        while (n2 != 0) {
            n4 = Integer.numberOfTrailingZeros(n2);
            if (n4 == 0) {
                n4 = Integer.numberOfTrailingZeros(65535 - n2);
            }
            G2DStroke.array[n3++] = n4;
            n2 >>= n4;
        }
        G2DStroke.array[n3] = n5;
        float[] fArray = new float[n3 + 1];
        for (n = 0; n <= n3; ++n) {
            fArray[n] = (float)array[n] * f;
        }
        return fArray;
    }

    static {
        prevFactor = -1.0f;
        prevPattern = (short)-1;
    }
}

