/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.motor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import org.scilab.forge.scirenderer.implementation.g2d.motor.AbstractDrawable3DObject;
import org.scilab.forge.scirenderer.implementation.g2d.motor.BoundingBox;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Clippable;
import org.scilab.forge.scirenderer.implementation.g2d.motor.InvalidPolygonException;
import org.scilab.forge.scirenderer.implementation.g2d.motor.Segment;
import org.scilab.forge.scirenderer.tranformations.Vector3d;
import org.scilab.forge.scirenderer.tranformations.Vector4d;

public abstract class ConvexObject
extends AbstractDrawable3DObject
implements Clippable {
    private List<ConvexObject> areas;

    public ConvexObject(Vector3d[] vector3dArray, Color[] colorArray) throws InvalidPolygonException {
        super(vector3dArray, colorArray);
    }

    public abstract List<ConvexObject> breakObject(ConvexObject var1);

    @Override
    public abstract List<ConvexObject> breakObject(Vector4d var1);

    public void addArea(ConvexObject convexObject) {
        if (this.areas == null) {
            this.areas = new ArrayList<ConvexObject>();
        }
        this.areas.add(convexObject);
    }

    protected void drawAreas(Graphics2D graphics2D) {
        if (this.areas != null) {
            for (ConvexObject convexObject : this.areas) {
                Shape shape = graphics2D.getClip();
                graphics2D.clip(this.getProjectedContour());
                convexObject.draw(graphics2D);
                graphics2D.setClip(shape);
            }
        }
    }

    public boolean areCoplanar(ConvexObject convexObject) {
        if (!(this instanceof Segment)) {
            double d = this.vertices[0].scalar(this.getNormal());
            if (convexObject instanceof Segment) {
                return ConvexObject.isEqual(d, convexObject.vertices[0].scalar(this.v0v1)) && ConvexObject.isEqual(d, convexObject.vertices[1].scalar(this.v0v1));
            }
            return ConvexObject.isEqual(d, convexObject.vertices[0].scalar(this.v0v1)) && ConvexObject.isEqual(d, convexObject.vertices[1].scalar(this.v0v1)) && ConvexObject.isEqual(d, convexObject.vertices[2].scalar(this.v0v1));
        }
        if (!(convexObject instanceof Segment)) {
            return convexObject.areCoplanar(this);
        }
        if (convexObject.vertices[0].equals(this.vertices[0]) || convexObject.vertices[1].equals(this.vertices[0]) || convexObject.vertices[0].equals(this.vertices[1]) || convexObject.vertices[1].equals(this.vertices[1])) {
            return true;
        }
        this.getNormal();
        convexObject.getNormal();
        Vector3d vector3d = Vector3d.product(this.v0, convexObject.v0);
        return ConvexObject.isNull(vector3d.scalar(this.vertices[0].minus(convexObject.vertices[0])));
    }

    public int isBehind(ConvexObject convexObject) {
        BoundingBox boundingBox;
        BoundingBox boundingBox2 = this.getBBox();
        if (boundingBox2.isNonZOverlapping(boundingBox = convexObject.getBBox())) {
            return 0;
        }
        if (this.check2DIntersection(convexObject)) {
            if (this.areCoplanar(convexObject)) {
                return this.getPrecedence() > convexObject.getPrecedence() ? 1 : -1;
            }
            int n = boundingBox2.zCompare(boundingBox);
            if (n != 0) {
                return n;
            }
            n = this.check(convexObject, this.getNormal());
            if (n != 0) {
                return n;
            }
            n = this.check(convexObject, convexObject.getNormal());
            if (n != 0) {
                return n;
            }
            int n2 = this.vertices.length == 2 ? 1 : this.vertices.length;
            int n3 = convexObject.vertices.length == 2 ? 1 : convexObject.vertices.length;
            for (int i = 0; i < n2; ++i) {
                int n4 = i + 1 < this.vertices.length ? i + 1 : 0;
                Vector3d vector3d = this.vertices[n4].minus(this.vertices[i]);
                for (int j = 0; j < n3; ++j) {
                    int n5 = j + 1 < convexObject.vertices.length ? j + 1 : 0;
                    Vector3d vector3d2 = convexObject.vertices[n5].minus(convexObject.vertices[j]);
                    n = this.check(convexObject, Vector3d.product(vector3d, vector3d2).getNormalized());
                    if (n == 0) continue;
                    return n;
                }
            }
            return 2;
        }
        return 0;
    }

    public boolean check2DIntersection(ConvexObject convexObject) {
        int n = ConvexObject.check2D(this, convexObject);
        if (n != -1) {
            return false;
        }
        n = ConvexObject.check2D(convexObject, this);
        return n == -1;
    }

    public boolean check2DTrueIntersection(ConvexObject convexObject) {
        int n = ConvexObject.check2D2(this, convexObject);
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        n = ConvexObject.check2D2(convexObject, this);
        if (n == 1) {
            return true;
        }
        return n != 0;
    }

    private static final int check2D(ConvexObject convexObject, ConvexObject convexObject2) {
        int n = convexObject.vertices.length == 2 ? 1 : convexObject.vertices.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1 < convexObject.vertices.length ? i + 1 : 0;
            double d = convexObject.vertices[i].getY() - convexObject.vertices[n2].getY();
            double d2 = convexObject.vertices[n2].getX() - convexObject.vertices[i].getX();
            double d3 = Math.hypot(d, d2);
            double[] dArray = ConvexObject.minmax2D(convexObject, d /= d3, d2 /= d3);
            double d4 = dArray[0];
            double d5 = dArray[1];
            dArray = ConvexObject.minmax2D(convexObject2, d, d2);
            double d6 = dArray[0];
            double d7 = dArray[1];
            if (d5 < d6 || d7 < d4) {
                return 0;
            }
            if (!ConvexObject.isEqual(d5, d6) && !ConvexObject.isEqual(d7, d4)) continue;
            return 1;
        }
        return -1;
    }

    private static final int check2D2(ConvexObject convexObject, ConvexObject convexObject2) {
        int n = convexObject.vertices.length == 2 ? 1 : convexObject.vertices.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1 < convexObject.vertices.length ? i + 1 : 0;
            double d = convexObject.vertices[i].getY() - convexObject.vertices[n2].getY();
            double d2 = convexObject.vertices[n2].getX() - convexObject.vertices[i].getX();
            double d3 = Math.hypot(d, d2);
            double[] dArray = ConvexObject.minmax2D(convexObject, d /= d3, d2 /= d3);
            double d4 = dArray[0];
            double d5 = dArray[1];
            dArray = ConvexObject.minmax2D(convexObject2, d, d2);
            double d6 = dArray[0];
            double d7 = dArray[1];
            if (d5 < d6 || d7 < d4) {
                return 0;
            }
            if (bl || !ConvexObject.isEqual(d5, d6) && !ConvexObject.isEqual(d7, d4)) continue;
            bl = true;
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    protected int check(ConvexObject convexObject, Vector3d vector3d) {
        if (!vector3d.isNearZero()) {
            double[] dArray = ConvexObject.minmax3D(this, vector3d);
            double d = dArray[0];
            double d2 = dArray[1];
            dArray = ConvexObject.minmax3D(convexObject, vector3d);
            double d3 = dArray[0];
            double d4 = dArray[1];
            double d5 = vector3d.getZ();
            if (Math.signum(d5) == 0.0) {
                return 0;
            }
            if (ConvexObject.isLowerOrEqual(d2, d3)) {
                return (int)Math.signum(d5);
            }
            if (ConvexObject.isLowerOrEqual(d4, d)) {
                return (int)(-Math.signum(d5));
            }
        }
        return 0;
    }
}

