/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.scirenderer.implementation.g2d.buffers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.scilab.forge.scirenderer.buffers.BuffersManager;
import org.scilab.forge.scirenderer.buffers.DataBuffer;
import org.scilab.forge.scirenderer.buffers.ElementsBuffer;
import org.scilab.forge.scirenderer.buffers.IndicesBuffer;
import org.scilab.forge.scirenderer.implementation.g2d.buffers.G2DElementsBuffer;
import org.scilab.forge.scirenderer.implementation.g2d.buffers.G2DIndicesBuffer;

public final class G2DBuffersManager
implements BuffersManager {
    private final Set<DataBuffer> buffers = new HashSet<DataBuffer>();

    @Override
    public ElementsBuffer createElementsBuffer() {
        G2DElementsBuffer g2DElementsBuffer = new G2DElementsBuffer();
        this.buffers.add(g2DElementsBuffer);
        return g2DElementsBuffer;
    }

    @Override
    public IndicesBuffer createIndicesBuffer() {
        G2DIndicesBuffer g2DIndicesBuffer = new G2DIndicesBuffer();
        this.buffers.add(g2DIndicesBuffer);
        return g2DIndicesBuffer;
    }

    @Override
    public void dispose(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.getLocalBuffer(dataBuffer);
        if (dataBuffer2 != null) {
            dataBuffer2.clear();
            this.buffers.remove(dataBuffer2);
        }
    }

    @Override
    public void dispose(Collection<? extends DataBuffer> collection) {
        for (DataBuffer dataBuffer : collection) {
            this.dispose(dataBuffer);
        }
    }

    private DataBuffer getLocalBuffer(DataBuffer dataBuffer) {
        if (this.buffers.contains(dataBuffer)) {
            return dataBuffer;
        }
        return null;
    }

    private IndicesBuffer getLocalIndicesBuffer(IndicesBuffer indicesBuffer) {
        if (indicesBuffer instanceof G2DIndicesBuffer && this.buffers.contains(indicesBuffer)) {
            return indicesBuffer;
        }
        return null;
    }

    private ElementsBuffer getLocalElementsBuffer(ElementsBuffer elementsBuffer) {
        if (elementsBuffer instanceof G2DElementsBuffer && this.buffers.contains(elementsBuffer)) {
            return elementsBuffer;
        }
        return null;
    }
}

