/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Color;
import org.scilab.modules.gui.bridge.slider.SwingScilabSlider;
import org.scilab.modules.gui.widget.Widget;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class Slider
extends SwingScilabSlider
implements XComponent,
Widget {
    private static final long serialVersionUID = -4842434795956015957L;

    public Slider(Node node) {
        this.setHorizontal();
        String string = XConfigManager.getAttribute(node, "tooltip");
        this.tooltip(string);
        String string2 = XConfigManager.getAttribute(node, "background");
        this.background(string2);
        String string3 = XConfigManager.getAttribute(node, "foreground");
        this.foreground(string3);
    }

    @Override
    public final String[] actuators() {
        String[] stringArray = new String[]{"foreground", "background", "tooltip"};
        return stringArray;
    }

    @Override
    public void refresh(Node node) {
        String string;
        String string2;
        String string3 = XConfigManager.getAttribute(node, "tooltip");
        if (!string3.equals(this.tooltip())) {
            this.tooltip(string3);
        }
        if (!(string2 = XConfigManager.getAttribute(node, "background")).equals(this.background())) {
            this.background(string2);
        }
        if (!(string = XConfigManager.getAttribute(node, "foreground")).equals(this.foreground())) {
            this.foreground(string);
        }
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
    }

    public final String tooltip() {
        String string = this.getToolTipText();
        if (string == null) {
            return "";
        }
        return string;
    }

    public final String foreground() {
        if (this.getForeground().equals(this.getParent().getForeground())) {
            return "\"not an value'";
        }
        return XConfigManager.getColor(this.getForeground());
    }

    public final String background() {
        if (this.getForeground().equals(this.getParent().getBackground())) {
            return "\"not an value'";
        }
        return XConfigManager.getColor(this.getBackground());
    }

    public final void tooltip(String string) {
        if (string.equals("\"not an value'") || string.equals("")) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(string);
        }
    }

    public final void foreground(String string) {
        if (string.equals("\"not an value'")) {
            this.setForeground(null);
        } else {
            Color color = XConfigManager.getColor(string);
            this.setForeground(color);
        }
    }

    public final void background(String string) {
        if (string.equals("\"not an value'")) {
            this.setOpaque(false);
            this.setBackground(null);
        } else {
            Color color = XConfigManager.getColor(string);
            this.setOpaque(true);
            this.setBackground(color);
        }
    }

    public final String toString() {
        Object object = "Label";
        if (!this.background().equals("\"not an value'")) {
            object = (String)object + " background='" + this.background() + "'";
        }
        if (!this.foreground().equals("\"not an value'")) {
            object = (String)object + " foreground='" + this.foreground() + "'";
        }
        return object;
    }
}

