/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.preferences.Component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.scilab.modules.gui.bridge.fontchooser.SwingScilabFontChooser;
import org.scilab.modules.preferences.Component.Panel;
import org.scilab.modules.preferences.XChooser;
import org.scilab.modules.preferences.XComponent;
import org.scilab.modules.preferences.XConfigManager;
import org.w3c.dom.Node;

public class FontSelector
extends Panel
implements XComponent,
XChooser {
    private static final long serialVersionUID = -4842434795956015959L;
    private ActionListener actionListener;
    private JTextField textField;
    private JButton button;
    private Font font = new Font("Monospaced", 0, 12);
    private int defaultSize;

    @Override
    public final String[] actuators() {
        return new String[]{"font-name", "font-face", "font-size", "enable"};
    }

    public FontSelector(Node node) {
        super(node);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        this.textField = new JTextField();
        this.defaultSize = this.textField.getFont().getSize();
        this.textField.setEditable(false);
        this.button = new JButton("...");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, FontSelector.this);
                SwingScilabFontChooser swingScilabFontChooser = new SwingScilabFontChooser(jFrame, FontSelector.this.font, false);
                swingScilabFontChooser.setLocationRelativeTo((Component)jFrame);
                swingScilabFontChooser.displayAndWait();
                Font font = swingScilabFontChooser.getSelectedFont();
                if (font != null && !font.equals(FontSelector.this.font)) {
                    FontSelector.this.font = font;
                    FontSelector.this.setTextField();
                    if (FontSelector.this.actionListener != null) {
                        FontSelector.this.actionListener.actionPerformed(new ActionEvent(FontSelector.this, 0, "Font Selector Value changed", System.currentTimeMillis(), 0));
                    }
                }
            }
        });
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.textField).addComponent(this.button));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup().addComponent(this.textField).addComponent(this.button));
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        String string = XConfigManager.getAttribute(node, "font-name");
        this.fontname(string);
        String string2 = XConfigManager.getAttribute(node, "font-face");
        this.fontface(string2);
        String string3 = XConfigManager.getAttribute(node, "font-size");
        this.fontsize(string3);
    }

    private void setTextField() {
        this.textField.setFont(this.font.deriveFont((float)this.defaultSize));
        this.textField.setText(this.fontname() + " " + this.fontsize() + " " + this.fontface());
    }

    @Override
    public void refresh(Node node) {
        String string;
        String string2;
        String string3 = XConfigManager.getAttribute(node, "font-name");
        if (!string3.equals(this.fontname())) {
            this.fontname(string3);
        }
        if (!(string2 = XConfigManager.getAttribute(node, "font-face")).equals(this.fontface())) {
            this.fontface(string2);
        }
        if (!(string = XConfigManager.getAttribute(node, "font-size")).equals(this.fontsize())) {
            this.fontsize(string);
        }
        String string4 = XConfigManager.getAttribute(node, "enable", "true");
        this.textField.setEnabled(string4.equals("true"));
        this.button.setEnabled(string4.equals("true"));
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public final String fontsize() {
        return Integer.toString(this.font.getSize());
    }

    public final String fontface() {
        switch (this.font.getStyle()) {
            case 0: {
                return "plain";
            }
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bold italic";
            }
        }
        return "plain";
    }

    public final String fontname() {
        return this.font.getName();
    }

    public final void fontsize(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            try {
                int n = Integer.parseInt(string);
                this.font = this.font.deriveFont((float)n);
                this.setTextField();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public final void fontface(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            int n = 0;
            if (string.equalsIgnoreCase("bold")) {
                n = 1;
            } else if (string.equalsIgnoreCase("italic")) {
                n = 2;
            } else if (string.equalsIgnoreCase("bold italic")) {
                n = 3;
            }
            this.font = this.font.deriveFont(n);
            this.setTextField();
        }
    }

    public final void fontname(String string) {
        if (!string.equals("\"not an value'") && !string.equals("")) {
            this.font = new Font(string, this.font.getStyle(), this.font.getSize());
            this.setTextField();
        }
    }

    @Override
    public final Object choose() {
        return new String[]{this.fontname(), this.fontface(), this.fontsize()};
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("FontSelector");
        if (!this.fontname().equals("\"not an value'")) {
            stringBuilder.append(" font-name='");
            stringBuilder.append(this.fontname());
            stringBuilder.append("'");
        }
        if (!this.fontface().equals("\"not an value'")) {
            stringBuilder.append(" font-face='");
            stringBuilder.append(this.fontface());
            stringBuilder.append("'");
        }
        if (!this.fontsize().equals("\"not an value'")) {
            stringBuilder.append(" font-size='");
            stringBuilder.append(this.fontsize());
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }
}

