/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.event.EventListenerList;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;

public abstract class SearchQuery {
    protected EventListenerList listenerList = new EventListenerList();
    protected SearchEngine hs;
    protected String searchparams;
    protected Locale l;
    private static final boolean debug = false;

    public SearchQuery(SearchEngine hs) {
        this.hs = hs;
    }

    public void addSearchListener(SearchListener l) {
        this.listenerList.add(SearchListener.class, l);
    }

    public void removeSearchListener(SearchListener l) {
        this.listenerList.remove(SearchListener.class, l);
    }

    public void start(String searchparams, Locale l) throws IllegalArgumentException, IllegalStateException {
        this.searchparams = searchparams;
        this.l = l;
        this.fireSearchStarted();
    }

    public void stop() throws IllegalStateException {
        this.fireSearchFinished();
    }

    public SearchEngine getSearchEngine() {
        return this.hs;
    }

    public abstract boolean isActive();

    public void itemsFound(boolean inSearch, Vector docs) {
        this.fireItemsFound(inSearch, docs);
    }

    protected void fireItemsFound(boolean inSearch, Vector docs) {
        SearchQuery.debug("fireItemsFound");
        SearchQuery.debug("  params: " + this.searchparams);
        SearchQuery.debug("  insearch: " + inSearch);
        SearchQuery.debug("  docs: " + docs);
        Object[] listeners = this.listenerList.getListenerList();
        SearchEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            if (e == null) {
                e = new SearchEvent(this, this.searchparams, inSearch, docs);
            }
            ((SearchListener)listeners[i + 1]).itemsFound(e);
        }
    }

    protected void fireItemsFound(SearchEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        Vector<SearchItem> newItems = new Vector<SearchItem>();
        Enumeration enum1 = e.getSearchItems();
        while (enum1.hasMoreElements()) {
            newItems.addElement((SearchItem)enum1.nextElement());
        }
        SearchEvent e2 = new SearchEvent(this, e.getParams(), e.isSearchCompleted(), newItems);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            ((SearchListener)listeners[i + 1]).itemsFound(e2);
        }
    }

    protected void fireSearchStarted() {
        SearchQuery.debug("fireSearchStarted");
        Object[] listeners = this.listenerList.getListenerList();
        SearchEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            if (e == null) {
                e = new SearchEvent(this, this.searchparams, true);
            }
            ((SearchListener)listeners[i + 1]).searchStarted(e);
        }
    }

    protected void fireSearchFinished() {
        SearchQuery.debug("fireSearchFinished");
        Object[] listeners = this.listenerList.getListenerList();
        SearchEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$help$search$SearchListener == null ? SearchQuery.class$("javax.help.search.SearchListener") : class$javax$help$search$SearchListener)) continue;
            if (e == null) {
                e = new SearchEvent(this, this.searchparams, false);
            }
            ((SearchListener)listeners[i + 1]).searchFinished(e);
        }
    }

    private static void debug(String msg) {
    }
}

