/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BlockManagerParameters;
import com.sun.java.help.search.Schema;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

class BtreeDictParameters
extends BlockManagerParameters {
    private int id1;
    private String dirName;
    private static boolean debugFlag = false;

    public BtreeDictParameters(URL fileName, int blockSize, int root, int freeID) {
        super(fileName, blockSize, root);
        this.id1 = freeID;
    }

    public BtreeDictParameters(Schema schema, String partName) throws Exception {
        super(schema, partName);
    }

    public boolean readState() {
        if (super.readState()) {
            this.setFreeID(this.integerParameter("id1"));
            return true;
        }
        return false;
    }

    public void writeState() {
    }

    public int getFreeID() {
        return this.id1;
    }

    public final void setFreeID(int id) {
        this.id1 = id;
    }

    private void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public static BtreeDictParameters create(URL dirName) {
        try {
            URL url = new URL(dirName, "TMAP");
            BtreeDictParameters bdp = null;
            super.setDirName(dirName.getFile());
            return bdp;
        }
        catch (MalformedURLException e) {
            System.out.println("Couldn't create " + dirName + File.separator + "TMAP");
            return null;
        }
    }

    public static BtreeDictParameters read(String dir, URL hsBase) throws Exception {
        String line;
        URL baseURL = null;
        URL tmapURL = null;
        int blockSize = -1;
        int rootPosition = -1;
        int freeID = -1;
        if (hsBase == null) {
            File file = new File(dir);
            if (file.exists()) {
                if (File.separatorChar != '/') {
                    dir = dir.replace(File.separatorChar, '/');
                }
                if (dir.lastIndexOf(File.separatorChar) != dir.length() - 1) {
                    dir = dir.concat(File.separator);
                }
                BtreeDictParameters.debug("file:" + dir);
                baseURL = new URL("file", "", dir);
            } else {
                baseURL = new URL(dir);
            }
        }
        URL url = hsBase != null ? new URL(hsBase, dir + "/SCHEMA") : new URL(baseURL, "SCHEMA");
        URLConnection connect = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connect.getInputStream()));
        while (!(line = in.readLine()).startsWith("TMAP")) {
        }
        in.close();
        StringTokenizer tokens = new StringTokenizer(line, " =");
        tokens.nextToken();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("bs")) {
                blockSize = Integer.parseInt(tokens.nextToken());
                continue;
            }
            if (token.equals("rt")) {
                rootPosition = Integer.parseInt(tokens.nextToken());
                continue;
            }
            if (!token.equals("id1")) continue;
            freeID = Integer.parseInt(tokens.nextToken());
        }
        tmapURL = hsBase != null ? new URL(hsBase, dir + "/TMAP") : new URL(baseURL, "TMAP");
        BtreeDictParameters bdp = null;
        if (hsBase == null) {
            super.setDirName(new File(baseURL.toURI()).getAbsolutePath());
        }
        return bdp;
    }

    public void updateSchema() {
        super.updateSchema("id1=" + this.id1 + " id2=1");
    }

    public void write() throws IOException {
        FileWriter out = new FileWriter(this.dirName + "/SCHEMA");
        out.write("JavaSearch 1.0\n");
        out.write("TMAP bs=2048 rt=" + this.root + " fl=-1 id1=" + this.id1 + " id2=1\n");
        out.close();
    }

    private static void debug(String str) {
        if (debugFlag) {
            System.out.println("BtreeDictParamters: " + str);
        }
    }
}

