/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.textObject;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.textObject.Font;

public class FormattedText {
    private String text;
    private Font font;
    private InterpreterType interpreter = InterpreterType.AUTO;

    public FormattedText() {
        this.text = "";
        this.font = new Font();
    }

    public FormattedText(String string, Font font) {
        this.text = string == null ? "" : string;
        this.font = font;
    }

    public FormattedText(FormattedText formattedText) {
        this.text = new String(formattedText.getText());
        this.font = new Font(formattedText.getFont());
    }

    public boolean equals(Object object) {
        if (object instanceof FormattedText) {
            FormattedText formattedText = (FormattedText)object;
            return formattedText.text.equals(this.text) && formattedText.font.equals(this.font);
        }
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public GraphicObject.UpdateStatus setFont(Font font) {
        this.font = font;
        return GraphicObject.UpdateStatus.Success;
    }

    public String getText() {
        return this.text;
    }

    public GraphicObject.UpdateStatus setText(String string) {
        this.text = string == null ? "" : string;
        return GraphicObject.UpdateStatus.Success;
    }

    public Integer getInterpreter() {
        return this.interpreter.ordinal();
    }

    public InterpreterType getInterpreterAsEnum() {
        return this.interpreter;
    }

    public GraphicObject.UpdateStatus setInterpreter(Integer n) {
        return this.setInterpreter(InterpreterType.intToEnum(n));
    }

    public GraphicObject.UpdateStatus setInterpreter(InterpreterType interpreterType) {
        if (this.interpreter == interpreterType) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.interpreter = interpreterType;
        return GraphicObject.UpdateStatus.Success;
    }

    public static enum InterpreterType {
        AUTO,
        LATEX,
        MATHML,
        NONE;


        public static InterpreterType intToEnum(Integer n) {
            switch (n) {
                default: {
                    return AUTO;
                }
                case 1: {
                    return LATEX;
                }
                case 2: {
                    return MATHML;
                }
                case 3: 
            }
            return NONE;
        }

        public static InterpreterType stringToEnum(String string) {
            if (string.equals("latex")) {
                return LATEX;
            }
            if (string.equals("mathml")) {
                return MATHML;
            }
            if (string.equals("none")) {
                return NONE;
            }
            return AUTO;
        }

        public static String enumToString(InterpreterType interpreterType) {
            switch (interpreterType) {
                case MATHML: {
                    return "mathml";
                }
                case LATEX: {
                    return "latex";
                }
                case NONE: {
                    return "none";
                }
            }
            return "auto";
        }
    }

    public static enum FormattedTextProperty {
        TEXT,
        FONT,
        INTERPRETER;

    }
}

