/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.graphicView;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.scilab.modules.graphic_objects.contouredObject.ContouredObject;
import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;
import org.scilab.modules.graphic_objects.graphicView.GraphicView;
import org.scilab.modules.graphic_objects.graphicView.LogView;
import org.scilab.modules.graphic_objects.uicontrol.Uicontrol;
import org.scilab.modules.graphic_objects.uicontrol.frame.border.FrameBorder;

public abstract class TreeView
implements GraphicView,
TreeSelectionListener {
    protected Map<Integer, DefaultMutableTreeNode> allObjects = new ConcurrentHashMap<Integer, DefaultMutableTreeNode>();
    protected DefaultTreeModel topModel = null;
    protected DefaultMutableTreeNode top = new DefaultMutableTreeNode("Graphic Objects");
    private JTree tree;
    private JEditorPane htmlDetailPane;
    private JFrame frame = new JFrame("TreeView");

    public void show() {
        this.frame.setVisible(true);
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    protected TreeView() {
        this.frame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel(new GridLayout(1, 0));
        this.topModel = new DefaultTreeModel(this.top);
        this.tree = new JTree(this.topModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        Dimension dimension = new Dimension(400, 300);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setMinimumSize(dimension);
        this.htmlDetailPane = new JEditorPane();
        this.htmlDetailPane.setEditable(false);
        this.htmlDetailPane.setContentType("text/html");
        JScrollPane jScrollPane2 = new JScrollPane(this.htmlDetailPane);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(jScrollPane2);
        jSplitPane.setDividerLocation(100);
        jSplitPane.setPreferredSize(new Dimension(1200, 600));
        jPanel.add(jSplitPane);
        this.frame.add(jPanel);
        this.frame.setVisible(false);
        this.frame.setSize(1200, 600);
    }

    @Override
    public abstract void createObject(Integer var1);

    @Override
    public abstract void deleteObject(Integer var1);

    @Override
    public abstract void updateObject(Integer var1, int var2);

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object == null || !(object instanceof DefaultMutableTreeNode)) {
            this.htmlDetailPane.setText("");
            return;
        }
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        if (object2 == null || !(object2 instanceof GraphicObjectNode)) {
            this.htmlDetailPane.setText("");
            return;
        }
        GraphicObjectNode graphicObjectNode = (GraphicObjectNode)object2;
        this.htmlDetailPane.setText(graphicObjectNode.toHTML());
    }

    protected static class GraphicObjectNode {
        private GraphicObject graphicObject;

        public GraphicObjectNode(GraphicObject graphicObject) {
            this.graphicObject = graphicObject;
        }

        public String toString() {
            return this.typeToString(this.graphicObject.getType()) + " : @" + this.graphicObject.getIdentifier().toString();
        }

        public String toHTML() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body>");
            stringBuffer.append("<h1>Graphic Object of type: " + this.typeToString(this.graphicObject.getType()) + "</h1>");
            stringBuffer.append("<h2> Id : " + this.graphicObject.getIdentifier() + "</h2>");
            stringBuffer.append("<table border=\"1\">");
            stringBuffer.append("<tr><th>Property Name</th><th>Value</th></tr>");
            for (GraphicObject.GraphicObjectPropertyType object2 : GraphicObject.GraphicObjectPropertyType.values()) {
                stringBuffer.append("<tr><td>");
                stringBuffer.append((Object)object2);
                stringBuffer.append("</td><td>");
                Object object3 = this.graphicObject.getProperty((Object)object2);
                if (object3 instanceof String[]) {
                    var7_9 = (String[])object3;
                    stringBuffer.append("{");
                    for (var8_10 = 0; var8_10 < var7_9.length; ++var8_10) {
                        stringBuffer.append((String)var7_9[var8_10] + ",");
                    }
                    stringBuffer.append("}");
                } else if (object3 instanceof Integer[]) {
                    var7_9 = (Integer[])object3;
                    stringBuffer.append("{");
                    for (var8_10 = 0; var8_10 < var7_9.length; ++var8_10) {
                        stringBuffer.append((Integer)var7_9[var8_10] + ",");
                    }
                    stringBuffer.append("}");
                } else if (object3 instanceof Double[]) {
                    var7_9 = (Double[])object3;
                    stringBuffer.append("{");
                    for (var8_10 = 0; var8_10 < var7_9.length; ++var8_10) {
                        stringBuffer.append((Double)var7_9[var8_10] + ",");
                    }
                    stringBuffer.append("}");
                } else if (object3 != null) {
                    if (object3.getClass().getPackage().getName().contains("scilab")) {
                        stringBuffer.append(object3.getClass().getCanonicalName());
                    } else {
                        stringBuffer.append(object3.toString());
                    }
                } else {
                    stringBuffer.append("??? NULL ???");
                }
                stringBuffer.append("</td></tr>");
            }
            if (this.graphicObject instanceof ContouredObject) {
                for (ContouredObject.ContouredObjectPropertyType contouredObjectPropertyType : ContouredObject.ContouredObjectPropertyType.values()) {
                    stringBuffer.append("<tr><td>");
                    stringBuffer.append((Object)contouredObjectPropertyType);
                    stringBuffer.append("</td><td>");
                    stringBuffer.append(this.graphicObject.getProperty((Object)contouredObjectPropertyType));
                    stringBuffer.append("</td></tr>");
                }
            }
            if (this.graphicObject instanceof Uicontrol) {
                object = (Uicontrol)this.graphicObject;
                stringBuffer.append("<tr><td>STYLE</td><td>" + this.typeToString(((Uicontrol)object).getStyle()) + "</td>");
                stringBuffer.append("<tr><td>LAYOUT</td><td>" + String.valueOf((Object)((Uicontrol)object).getLayoutAsEnum()) + "</td>");
                stringBuffer.append("<tr><td>GROUP NAME</td><td>" + ((Uicontrol)object).getGroupName() + "</td>");
                stringBuffer.append("<tr><td>FRAME_BORDER</td><td>" + ((Uicontrol)object).getFrameBorder() + "</td>");
            }
            if (this.graphicObject instanceof FrameBorder) {
                object = (FrameBorder)this.graphicObject;
                stringBuffer.append("<tr><td>STYLE</td><td>" + ((FrameBorder)object).getStyleAsEnum().toString() + "</td>");
            }
            stringBuffer.append("</table>");
            stringBuffer.append("</body></html>");
            return stringBuffer.toString();
        }

        private String typeToString(Integer n) {
            return LogView.pierreDeRosette.get(n);
        }
    }
}

