/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.graphic_objects.contouredObject;

import org.scilab.modules.graphic_objects.graphicObject.GraphicObject;

public class Line {
    private boolean mode;
    private LineType lineStyle;
    private double thickness;
    private int color;

    public Line() {
        this.mode = false;
        this.lineStyle = LineType.SOLID;
        this.thickness = 1.0;
        this.color = -1;
    }

    public Line(Line line) {
        this.mode = line.mode;
        this.lineStyle = line.lineStyle;
        this.thickness = line.thickness;
        this.color = line.color;
    }

    public Integer getColor() {
        return this.color;
    }

    public GraphicObject.UpdateStatus setColor(Integer n) {
        if (this.color == n) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.color = n;
        return GraphicObject.UpdateStatus.Success;
    }

    public LineType getLineStyle() {
        return this.lineStyle;
    }

    public GraphicObject.UpdateStatus setLineStyle(LineType lineType) {
        if (this.lineStyle != lineType) {
            this.lineStyle = lineType;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public Boolean getMode() {
        return this.mode;
    }

    public GraphicObject.UpdateStatus setMode(Boolean bl) {
        if (this.mode == bl) {
            return GraphicObject.UpdateStatus.NoChange;
        }
        this.mode = bl;
        return GraphicObject.UpdateStatus.Success;
    }

    public Double getThickness() {
        return this.thickness;
    }

    public GraphicObject.UpdateStatus setThickness(Double d) {
        if (this.thickness != d) {
            this.thickness = d;
            return GraphicObject.UpdateStatus.Success;
        }
        return GraphicObject.UpdateStatus.NoChange;
    }

    public static enum LineType {
        SOLID,
        DASH,
        DASH_DOT,
        LONG_DASH_DOT,
        BIG_DASH_DOT,
        BIG_DASH_LONG_DASH,
        DOT,
        DOUBLE_DOT,
        LONG_BLANK_DOT,
        BIG_BLANK_DOT;


        public static LineType fromScilabIndex(Integer n) {
            switch (n) {
                case 1: {
                    return SOLID;
                }
                case 2: {
                    return DASH;
                }
                case 3: {
                    return DASH_DOT;
                }
                case 4: {
                    return LONG_DASH_DOT;
                }
                case 5: {
                    return BIG_DASH_DOT;
                }
                case 6: {
                    return BIG_DASH_LONG_DASH;
                }
                case 7: {
                    return DOT;
                }
                case 8: {
                    return DOUBLE_DOT;
                }
                case 9: {
                    return LONG_BLANK_DOT;
                }
                case 10: {
                    return BIG_BLANK_DOT;
                }
            }
            return SOLID;
        }

        public int asScilabIndex() {
            return this.ordinal() + 1;
        }

        public short asPattern() {
            switch (this) {
                case DASH: {
                    return 2047;
                }
                case DASH_DOT: {
                    return 3855;
                }
                case LONG_DASH_DOT: {
                    return 8130;
                }
                case BIG_DASH_DOT: {
                    return 16329;
                }
                case BIG_DASH_LONG_DASH: {
                    return 16326;
                }
                case DOT: {
                    return 21845;
                }
                case DOUBLE_DOT: {
                    return 13107;
                }
                case LONG_BLANK_DOT: {
                    return 4369;
                }
                case BIG_BLANK_DOT: {
                    return 257;
                }
            }
            return -1;
        }
    }

    public static enum LinePropertyType {
        MODE,
        LINESTYLE,
        THICKNESS,
        COLOR;

    }
}

