/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultEditorKit;
import org.scilab.modules.commons.gui.FindIconHelper;
import org.scilab.modules.gui.events.callback.CommonCallBack;
import org.scilab.modules.ui_data.filebrowser.SwingScilabTreeTable;
import org.scilab.modules.ui_data.utils.UiDataMessages;

public class ScilabFileSelectorFilter
extends JPanel {
    private static final int GAP = 3;
    private MyJTextField textfield;
    private final SwingScilabTreeTable stt;
    private JToggleButton caseSensitive;
    private JToggleButton regexp;

    public ScilabFileSelectorFilter(SwingScilabTreeTable swingScilabTreeTable) {
        this.stt = swingScilabTreeTable;
        this.initPanel();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(0, 0, 3, 0));
        this.setLayout(new BorderLayout());
        this.textfield = new MyJTextField();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textfield, "Center");
    }

    private void testPattern() {
        if (this.regexp.isSelected()) {
            if (this.getPattern() == null) {
                this.textfield.setForeground(Color.RED);
            } else {
                this.textfield.setForeground(this.textfield.defaultFg);
            }
        }
    }

    private Pattern getPattern() {
        Object object = this.textfield.getText();
        if (object != null && !((String)object).isEmpty()) {
            if (!this.regexp.isSelected()) {
                object = ((String)object).replaceAll("\\*", "\\\\E.*\\\\Q").replaceAll("\\?", "\\\\E.?\\\\Q");
                object = "\\Q" + (String)object + "\\E";
            }
            if (!this.caseSensitive.isSelected()) {
                object = "(?i)" + (String)object;
            }
            if (this.regexp.isSelected()) {
                object = "(?m)" + (String)object;
            }
            try {
                return Pattern.compile((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private class MyJTextField
    extends JPanel {
        JTextFieldWithPlaceHolder textField;
        Color defaultFg;

        MyJTextField() {
            this.setLayout(new GridBagLayout());
            this.textField = new JTextFieldWithPlaceHolder();
            this.defaultFg = this.textField.defaultFg;
            this.setBackground(this.textField.getBackground());
            this.setBorder(this.textField.getBorder());
            this.textField.setBorder(null);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            ScilabFileSelectorFilter.this.caseSensitive = new JToggleButton(new ImageIcon(FindIconHelper.findIcon((String)"case-sensitive")));
            ScilabFileSelectorFilter.this.caseSensitive.setToolTipText(UiDataMessages.CASESENSITIVE);
            ScilabFileSelectorFilter.this.caseSensitive.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)ScilabFileSelectorFilter.this.caseSensitive, gridBagConstraints);
            ScilabFileSelectorFilter.this.regexp = new JToggleButton(new ImageIcon(FindIconHelper.findIcon((String)"regex")));
            ScilabFileSelectorFilter.this.regexp.setToolTipText(UiDataMessages.REGEXP);
            ScilabFileSelectorFilter.this.regexp.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            this.add((Component)ScilabFileSelectorFilter.this.regexp, gridBagConstraints);
            JButton jButton = new JButton((Action)new CommonCallBack(null){

                public void callBack() {
                    MyJTextField.this.textField.setText("");
                    ScilabFileSelectorFilter.this.stt.setFilter(ScilabFileSelectorFilter.this.getPattern());
                    MyJTextField.this.textField.toggleContents();
                }
            });
            jButton.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"clear")));
            jButton.setToolTipText(UiDataMessages.CLEAR);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            this.add((Component)jButton, gridBagConstraints);
            JButton jButton2 = new JButton((Action)new CommonCallBack(null){

                public void callBack() {
                    ScilabFileSelectorFilter.this.stt.setFilter(ScilabFileSelectorFilter.this.getPattern());
                }
            });
            jButton2.setIcon(new ImageIcon(FindIconHelper.findIcon((String)"filter")));
            jButton2.setToolTipText(UiDataMessages.RUNFILTER);
            jButton2.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 0;
            this.add((Component)jButton2, gridBagConstraints);
        }

        String getText() {
            return this.textField.getText();
        }
    }

    private class JTextFieldWithPlaceHolder
    extends JTextField
    implements DocumentListener,
    FocusListener {
        boolean isEmpty = true;
        Color defaultFg = this.getForeground();

        JTextFieldWithPlaceHolder() {
            this.setEditable(true);
            this.setComponentPopupMenu(this.createPopup());
            this.addFocusListener(this);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER");
            this.getActionMap().put("ENTER", (Action)new CommonCallBack(null){

                public void callBack() {
                    ScilabFileSelectorFilter.this.stt.setFilter(ScilabFileSelectorFilter.this.getPattern());
                }
            });
            this.toggleContents();
        }

        private void toggleContents() {
            if (this.isEmpty) {
                this.setForeground(Color.LIGHT_GRAY);
                this.setText(UiDataMessages.FILEFILTER);
            }
        }

        @Override
        public String getText() {
            if (this.isEmpty) {
                return "";
            }
            return super.getText();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.getDocument().addDocumentListener(this);
            if (this.isEmpty) {
                this.setForeground(this.defaultFg);
                this.setText("");
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.getDocument().removeDocumentListener(this);
            this.isEmpty = super.getText().isEmpty();
            this.toggleContents();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.isEmpty = super.getText().isEmpty();
            ScilabFileSelectorFilter.this.testPattern();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.isEmpty = super.getText().isEmpty();
            ScilabFileSelectorFilter.this.testPattern();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(UiDataMessages.CUT);
            jMenuItem.addActionListener(new DefaultEditorKit.CutAction());
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(UiDataMessages.COPY);
            jMenuItem.addActionListener(new DefaultEditorKit.CopyAction());
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(UiDataMessages.PASTE);
            jMenuItem.addActionListener(new DefaultEditorKit.PasteAction());
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(UiDataMessages.CLEAR);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JTextFieldWithPlaceHolder.this.setText("");
                }
            });
            jPopupMenu.add(jMenuItem);
            return jPopupMenu;
        }
    }
}

