/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.modules.ui_data.filebrowser;

import java.util.Comparator;
import org.scilab.modules.commons.OS;
import org.scilab.modules.ui_data.filebrowser.FileNode;

public final class FileComparators {
    private static final boolean isWindows = OS.get() == OS.WINDOWS;
    public static final Comparator<FileNode> ASCENDING_ALPHA = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            if (fileNode.isFile == fileNode2.isFile) {
                int n;
                if (isWindows) {
                    n = fileNode.name.compareToIgnoreCase(fileNode2.name);
                    if (n == 0) {
                        n = fileNode.name.compareTo(fileNode2.name);
                    }
                } else {
                    n = fileNode.name.compareTo(fileNode2.name);
                }
                return n;
            }
            if (fileNode.isFile) {
                return 1;
            }
            return -1;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> DESCENDING_ALPHA = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            return -ASCENDING_ALPHA.compare(fileNode, fileNode2);
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> ASCENDING_DATE = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            long l = fileNode.lastModified - fileNode2.lastModified;
            if (l == 0L) {
                return ASCENDING_ALPHA.compare(fileNode, fileNode2);
            }
            return l > 0L ? 1 : -1;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> DESCENDING_DATE = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            return -ASCENDING_DATE.compare(fileNode, fileNode2);
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> ASCENDING_SIZE = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            long l = fileNode.length - fileNode2.length;
            if (l == 0L) {
                return ASCENDING_ALPHA.compare(fileNode, fileNode2);
            }
            return l > 0L ? 1 : -1;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> DESCENDING_SIZE = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            return -ASCENDING_SIZE.compare(fileNode, fileNode2);
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> ASCENDING_TYPE = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            int n;
            if (isWindows) {
                n = fileNode.extension.compareToIgnoreCase(fileNode2.extension);
                if (n == 0) {
                    n = fileNode.extension.compareTo(fileNode2.extension);
                }
            } else {
                n = fileNode.extension.compareTo(fileNode2.extension);
            }
            if (n == 0) {
                return ASCENDING_ALPHA.compare(fileNode, fileNode2);
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
    public static final Comparator<FileNode> DESCENDING_TYPE = new Comparator<FileNode>(){

        @Override
        public int compare(FileNode fileNode, FileNode fileNode2) {
            return -ASCENDING_TYPE.compare(fileNode, fileNode2);
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    };
}

