/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.util;

import com.artenum.rosetta.interfaces.core.Configuration;
import com.artenum.rosetta.interfaces.core.ConsoleAction;
import com.artenum.rosetta.interfaces.core.ConsoleConfiguration;
import java.awt.Event;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationBuilder {
    protected static final String VALUE = "value";
    protected static final String NAME = "name";
    protected static final String ACTION = "action";
    protected static final String MASK = "mask";
    protected static final String CLASSNAME = "className";
    protected static final String USE_CACHE = "useCache";
    protected static final String KEY_MAPPING = "KeyMapping";
    protected static final String ACTION_MAPPING = "ActionMapping";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String METHOD_GET = "get";
    protected static final String METHOD_IS = "is";
    protected static final String PRIMITIVE_TYPE_NAME_INT = "int";
    protected static final String PRIMITIVE_TYPE_NAME_DOUBLE = "double";
    protected static final String PRIMITIVE_TYPE_NAME_BOOLEAN = "boolean";
    private static String version = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        if (version == null) {
            try {
                InputStream inputStream = ConfigurationBuilder.class.getClassLoader().getResourceAsStream("version.txt");
                if (inputStream == null) {
                    return null;
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                try {
                    version = bufferedReader.readLine();
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public static Object buildConfiguration(Class<?>[] resultClass, String fileToLoad) throws IllegalArgumentException, SAXException, IOException, ParserConfigurationException {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), resultClass, (InvocationHandler)new ConfigurationHandler(fileToLoad));
    }

    public static ConsoleConfiguration buildConfiguration(String fileToLoad) throws IllegalArgumentException, SAXException, IOException, ParserConfigurationException {
        return (ConsoleConfiguration)ConfigurationBuilder.buildConfiguration(new Class[]{ConsoleConfiguration.class}, fileToLoad);
    }

    private static class ConfigurationHandler
    implements InvocationHandler,
    Configuration {
        private final Collection<String> internalMethodNames;
        private String activeProfile;
        private final Document dom;
        private final ArrayList<String> profileList;
        private final Hashtable<String, Object> cache;
        private boolean useCache;
        private final ActionMap actionMap;
        private final InputMap inputMap;
        private Object proxy;

        public ConfigurationHandler(String xmlFile) throws SAXException, IOException, ParserConfigurationException {
            Method[] internalMethodes;
            if (!new File(xmlFile).exists()) {
                throw new IOException("Configuration file " + xmlFile + " not found");
            }
            this.internalMethodNames = new TreeSet<String>();
            for (Method method : internalMethodes = this.getClass().getMethods()) {
                this.internalMethodNames.add(method.getName());
            }
            this.dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(xmlFile));
            NodeList profiles = this.dom.getElementsByTagName("Profile");
            this.profileList = new ArrayList(profiles.getLength());
            for (int i = 0; i < profiles.getLength(); ++i) {
                this.profileList.add(profiles.item(i).getAttributes().getNamedItem(ConfigurationBuilder.NAME).getNodeValue());
            }
            this.cache = new Hashtable();
            this.inputMap = new InputMap();
            this.actionMap = new ActionMap();
        }

        public void setActiveProfile(String profileName) {
            this.activeProfile = profileName;
            this.inputMap.clear();
            this.actionMap.clear();
        }

        public String getActiveProfile() {
            return this.activeProfile;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.proxy = proxy;
            if (this.internalMethodNames.contains(method.getName())) {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            String key = null;
            if (method.getName().startsWith(ConfigurationBuilder.METHOD_GET)) {
                key = method.getName().substring(ConfigurationBuilder.METHOD_GET.length());
            }
            if (method.getName().startsWith(ConfigurationBuilder.METHOD_IS)) {
                key = method.getName().substring(ConfigurationBuilder.METHOD_IS.length());
            }
            String value = this.getPropertyValue(key);
            Object result = null;
            if (this.useCache && (result = this.cache.get(key)) != null) {
                return result;
            }
            if (method.getReturnType().equals(String.class)) {
                result = value;
            } else if (value.length() > 0) {
                result = method.getReturnType().getName().equals(ConfigurationBuilder.PRIMITIVE_TYPE_NAME_BOOLEAN) ? (Serializable)Boolean.valueOf(value) : (Serializable)(method.getReturnType().getName().equals(ConfigurationBuilder.PRIMITIVE_TYPE_NAME_INT) ? (Number)Integer.valueOf(value) : (Number)(method.getReturnType().getName().equals(ConfigurationBuilder.PRIMITIVE_TYPE_NAME_DOUBLE) ? Double.valueOf(value) : Class.forName(value).newInstance()));
            }
            if (result != null && this.useCache) {
                this.cache.put(key, result);
            }
            return result;
        }

        private int getActiveProfileIndex() {
            int result = this.profileList.indexOf(this.activeProfile);
            return result > -1 ? result : 0;
        }

        private String getPropertyValue(String propertyName) {
            NodeList elements = this.dom.getElementsByTagName(propertyName);
            if (elements.getLength() == 0) {
                return "";
            }
            NamedNodeMap attributes = elements.item(this.getActiveProfileIndex()).getAttributes();
            this.useCache = attributes.getNamedItem(ConfigurationBuilder.USE_CACHE) != null && attributes.getNamedItem(ConfigurationBuilder.USE_CACHE).getNodeValue().equalsIgnoreCase(ConfigurationBuilder.TRUE);
            return attributes.getNamedItem(ConfigurationBuilder.VALUE).getNodeValue();
        }

        public ActionMap getActionMapping() {
            if (this.actionMap.size() == 0) {
                NodeList actionElements = this.dom.getElementsByTagName(ConfigurationBuilder.ACTION_MAPPING).item(this.getActiveProfileIndex()).getChildNodes();
                Node element = null;
                String key = null;
                ConsoleAction action = null;
                for (int i = 0; i < actionElements.getLength(); ++i) {
                    element = actionElements.item(i);
                    if (element.getNodeType() == 3) continue;
                    key = element.getAttributes().getNamedItem(ConfigurationBuilder.NAME).getNodeValue();
                    try {
                        action = (ConsoleAction)Class.forName(element.getAttributes().getNamedItem(ConfigurationBuilder.CLASSNAME).getNodeValue()).newInstance();
                        action.setConfiguration((ConsoleConfiguration)this.proxy);
                        this.actionMap.put(key, (Action)action);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.err.println("Impossible to process ActionMapping with key=" + key);
                    }
                }
            }
            return this.actionMap;
        }

        public InputMap getKeyMapping() {
            if (this.inputMap.size() == 0) {
                NodeList keyElements = this.dom.getElementsByTagName(ConfigurationBuilder.KEY_MAPPING).item(this.getActiveProfileIndex()).getChildNodes();
                Node element = null;
                String name = null;
                String mask = null;
                String action = null;
                for (int i = 0; i < keyElements.getLength(); ++i) {
                    element = keyElements.item(i);
                    if (element.getNodeType() == 3) continue;
                    name = element.getAttributes().getNamedItem(ConfigurationBuilder.NAME).getNodeValue();
                    mask = element.getAttributes().getNamedItem(ConfigurationBuilder.MASK).getNodeValue();
                    action = element.getAttributes().getNamedItem(ConfigurationBuilder.ACTION).getNodeValue();
                    try {
                        this.inputMap.put(KeyStroke.getKeyStroke(this.convertKeyInformation(name), this.convertKeyInformation(mask)), action);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Impossible to process getKeyMapping with name=" + name + " mask=" + mask + " action=" + action);
                    }
                }
            }
            return this.inputMap;
        }

        private int convertKeyInformation(String value) {
            if (value == null || value.trim().length() == 0) {
                return 0;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                try {
                    return (Integer)KeyEvent.class.getField(value).get(null);
                }
                catch (Exception ee) {
                    try {
                        return (Integer)Event.class.getField(value).get(null);
                    }
                    catch (Exception eee) {
                        return 0;
                    }
                }
            }
        }
    }
}

