/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.rosetta.test;

import com.artenum.rosetta.interfaces.core.ConsoleConfiguration;
import com.artenum.rosetta.interfaces.ui.OutputView;
import com.artenum.rosetta.util.ConfigurationBuilder;
import com.artenum.rosetta.util.ConsoleBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class TestConsoleHistoryPerformance
implements Runnable {
    private OutputView outputView;
    private boolean writing;

    public TestConsoleHistoryPerformance(OutputView outputView) {
        this.outputView = outputView;
        this.writing = true;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long i = 0L;
        long startTime = System.currentTimeMillis();
        while (this.writing) {
            this.outputView.setCaretPositionToEnd();
            this.outputView.append(++i + " : qsdf qsdfaze azer\ufffdasdf, qmlsdjf \ufffdajzef:,; qsdfoj lkz f \n");
            this.writing = i < 25000L;
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.gc();
        this.writing = true;
        while (this.writing) {
            this.outputView.setCaretPositionToEnd();
            this.outputView.append(++i + " : qsdf qsdfaze azer\ufffdasdf, qmlsdjf \ufffdajzef:,; qsdfoj lkz f \n");
            this.outputView.setCaretPositionToEnd();
            this.writing = i < 40000L;
        }
        System.out.println("Time: " + (System.currentTimeMillis() - startTime));
    }

    public static void main(String[] args) throws Exception {
        String configFilePath = "resources/configuration.xml";
        String profileName = null;
        switch (args.length) {
            case 2: {
                configFilePath = args[1];
            }
            case 1: {
                profileName = args[0];
            }
        }
        if (!new File(configFilePath).exists()) {
            System.err.println("Three way of launch:");
            System.err.println(" - 0 argument: The first profile of the ./resources/configuration.xml will be loaded.");
            System.err.println(" - 1 argument: The specified profile name of the ./resources/configuration.xml will be loaded. (args1=profileName)");
            System.err.println(" - 2 arguments: The specified profile with the specified configuration file will be loaded. (args1=profileName args2=configurationFilePath)");
        } else {
            ConsoleConfiguration config = ConfigurationBuilder.buildConfiguration(configFilePath);
            config.setActiveProfile(profileName);
            JFrame window = new JFrame("Generic console");
            window.setDefaultCloseOperation(3);
            window.getContentPane().setLayout(new BorderLayout());
            window.getContentPane().add((Component)new JScrollPane(ConsoleBuilder.buildConsole(config, window)), "Center");
            window.setSize(600, 300);
            window.setLocationRelativeTo(null);
            window.setVisible(true);
            OutputView outputView = config.getOutputView();
            TestConsoleHistoryPerformance writingThread = new TestConsoleHistoryPerformance(outputView);
            new Thread(writingThread).start();
        }
    }
}

